--
-- NOTE:
--
-- File paths need to be edited. Search for $$PATH$$ and
-- replace it with the path to the directory containing
-- the extracted data files.
--
--
-- PostgreSQL database dump
--

-- Dumped from database version 14.15
-- Dumped by pg_dump version 14.15

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

DROP DATABASE vander_2024;
--
-- Name: vander_2024; Type: DATABASE; Schema: -; Owner: postgres
--

CREATE DATABASE vander_2024 WITH TEMPLATE = template0 ENCODING = 'UTF8' LOCALE = 'English_United States.1252';


ALTER DATABASE vander_2024 OWNER TO postgres;

\connect vander_2024

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: vander_2024; Type: DATABASE PROPERTIES; Schema: -; Owner: postgres
--

ALTER DATABASE vander_2024 SET "TimeZone" TO 'Asia/Singapore';


\connect vander_2024

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: daftar_peserta_selter_sekda_lamp_id_daftar_peserta_selter_sekda; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.daftar_peserta_selter_sekda_lamp_id_daftar_peserta_selter_sekda
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.daftar_peserta_selter_sekda_lamp_id_daftar_peserta_selter_sekda OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: l2_barcode; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_barcode (
    id_l2_barcode integer NOT NULL,
    id_l2_daftar_sampel_geotech integer,
    barcode character varying(60),
    nomor_dokumen character varying(120) DEFAULT NULL::character varying,
    nomor_wo character varying(120) DEFAULT NULL::character varying,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120)
);


ALTER TABLE public.l2_barcode OWNER TO postgres;

--
-- Name: l2_barcode_id_l2_barcode_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_barcode_id_l2_barcode_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_barcode_id_l2_barcode_seq OWNER TO postgres;

--
-- Name: l2_barcode_id_l2_barcode_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_barcode_id_l2_barcode_seq OWNED BY public.l2_barcode.id_l2_barcode;


--
-- Name: l2_daftar_admin; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_admin (
    id_l2_daftar_admin integer NOT NULL,
    username character varying(120) DEFAULT NULL::character varying,
    password character varying(120) DEFAULT NULL::character varying,
    nama character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    nik character varying(20),
    level smallint,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone,
    token integer,
    valid_token timestamp(6) without time zone,
    file_ttd character varying(120),
    jenis_pengujian smallint,
    pemberi_persetujuan smallint DEFAULT 0,
    jabatan character varying(60),
    departemen character varying(60),
    lokasi_kerja character varying(120)
);


ALTER TABLE public.l2_daftar_admin OWNER TO postgres;

--
-- Name: l2_daftar_admin_id_l2_daftar_admin_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_admin_id_l2_daftar_admin_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_admin_id_l2_daftar_admin_seq OWNER TO postgres;

--
-- Name: l2_daftar_admin_id_l2_daftar_admin_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_admin_id_l2_daftar_admin_seq OWNED BY public.l2_daftar_admin.id_l2_daftar_admin;


--
-- Name: l2_daftar_customer; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_customer (
    id_l2_daftar_customer integer NOT NULL,
    username character varying(120) DEFAULT NULL::character varying,
    password character varying(120) DEFAULT NULL::character varying,
    nama character varying(120) DEFAULT NULL::character varying,
    inisial character varying(20),
    cp character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    alamat character varying(240) DEFAULT NULL::character varying,
    level smallint,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone,
    token integer,
    valid_token timestamp(6) without time zone
);


ALTER TABLE public.l2_daftar_customer OWNER TO postgres;

--
-- Name: l2_daftar_customer_id_l2_daftar_customer_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_customer_id_l2_daftar_customer_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_customer_id_l2_daftar_customer_seq OWNER TO postgres;

--
-- Name: l2_daftar_customer_id_l2_daftar_customer_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_customer_id_l2_daftar_customer_seq OWNED BY public.l2_daftar_customer.id_l2_daftar_customer;


--
-- Name: l2_daftar_penawaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_penawaran (
    id_l2_daftar_penawaran integer NOT NULL,
    id_l2_daftar_customer integer,
    nomor_surat character varying(120) DEFAULT NULL::character varying,
    tanggal_penawaran timestamp(6) without time zone,
    nama character varying(120) DEFAULT NULL::character varying,
    inisial character varying(20),
    cp character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    alamat character varying(240) DEFAULT NULL::character varying,
    jenis_pengujian smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    sum_banyak smallint,
    sum_total integer,
    file_pdf character varying(120),
    revisi smallint,
    no_urut_surat smallint,
    status_persetujuan smallint DEFAULT 0,
    diskon smallint DEFAULT 0,
    harga_final integer DEFAULT 0,
    status_kirim_wa smallint DEFAULT 0,
    tanggal_kirim_wa timestamp without time zone,
    status_kirim_email smallint DEFAULT 0,
    tanggal_kirim_email timestamp without time zone
);


ALTER TABLE public.l2_daftar_penawaran OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_detail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_penawaran_detail (
    l2_daftar_penawaran_detail integer NOT NULL,
    id_l2_daftar_penawaran integer,
    id_l2_kategori_penawaran integer,
    id_l2_sub_kategori_penawaran integer,
    id_l2_sub_sub_kategori_penawaran integer,
    nama character varying(120) DEFAULT NULL::character varying,
    output character varying(60),
    standard character varying(60),
    qty smallint,
    rates integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan integer,
    banyak integer,
    sub_total integer,
    file_symbol character varying(120)
);


ALTER TABLE public.l2_daftar_penawaran_detail OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq OWNED BY public.l2_daftar_penawaran_detail.l2_daftar_penawaran_detail;


--
-- Name: l2_daftar_penawaran_id_l2_daftar_penawaran_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_penawaran_id_l2_daftar_penawaran_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_penawaran_id_l2_daftar_penawaran_seq OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_id_l2_daftar_penawaran_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_penawaran_id_l2_daftar_penawaran_seq OWNED BY public.l2_daftar_penawaran.id_l2_daftar_penawaran;


--
-- Name: l2_daftar_penawaran_lingkungan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_penawaran_lingkungan (
    id_l2_daftar_penawaran_lingkungan integer NOT NULL,
    id_l2_daftar_customer integer,
    nomor_surat character varying(120) DEFAULT NULL::character varying,
    tanggal_penawaran timestamp(6) without time zone,
    nama character varying(120) DEFAULT NULL::character varying,
    inisial character varying(20),
    cp character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    alamat character varying(240) DEFAULT NULL::character varying,
    jenis_pengujian smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    sum_banyak smallint,
    sum_total integer,
    file_pdf character varying(120),
    revisi smallint,
    no_urut_surat smallint,
    status_persetujuan smallint DEFAULT 0,
    diskon smallint DEFAULT 0,
    harga_final integer DEFAULT 0,
    status_kirim_wa smallint DEFAULT 0,
    tanggal_kirim_wa timestamp without time zone,
    status_kirim_email smallint DEFAULT 0,
    tanggal_kirim_email timestamp without time zone
);


ALTER TABLE public.l2_daftar_penawaran_lingkungan OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq OWNED BY public.l2_daftar_penawaran_lingkungan.id_l2_daftar_penawaran_lingkungan;


--
-- Name: l2_daftar_penawaran_lingkungan_detail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_penawaran_lingkungan_detail (
    l2_daftar_penawaran_lingkungan_detail integer NOT NULL,
    id_l2_daftar_penawaran_lingkungan integer,
    id_l2_kategori_penawaran_lingkungan integer,
    id_l2_sub_kategori_penawaran_lingkungan integer,
    id_l2_sub_sub_kategori_penawaran_lingkungan integer,
    nama character varying(320) DEFAULT NULL::character varying,
    output character varying(60),
    satuan character varying(60),
    volume smallint,
    harga integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan integer,
    banyak integer,
    sub_total integer,
    file_symbol character varying(120)
);


ALTER TABLE public.l2_daftar_penawaran_lingkungan_detail OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq OWNER TO postgres;

--
-- Name: l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq OWNED BY public.l2_daftar_penawaran_lingkungan_detail.l2_daftar_penawaran_lingkungan_detail;


--
-- Name: l2_daftar_sampel_geotech; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_sampel_geotech (
    id_l2_daftar_sampel_geotech integer NOT NULL,
    barcode character varying(60),
    id_l2_daftar_customer integer,
    nama character varying(120) DEFAULT NULL::character varying,
    inisial character varying(20),
    cp character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    alamat character varying(240) DEFAULT NULL::character varying,
    nomor_dokumen character varying(120) DEFAULT NULL::character varying,
    nomor_wo character varying(120) DEFAULT NULL::character varying,
    revisi smallint,
    tanggal_berlaku timestamp(6) without time zone,
    id_l2_daftar_admin integer,
    file_pdf character varying(120),
    status_persetujuan smallint DEFAULT 0,
    id_l2_daftar_admin_persetujuan integer,
    tanggal_persetujuan timestamp without time zone,
    tanggal_input timestamp without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    status_kirim_wa smallint DEFAULT 0,
    tanggal_kirim_wa timestamp without time zone,
    status_kirim_email smallint DEFAULT 0,
    tanggal_kirim_email timestamp without time zone,
    file_barcode character varying(120),
    no_urut_surat integer
);


ALTER TABLE public.l2_daftar_sampel_geotech OWNER TO postgres;

--
-- Name: l2_daftar_sampel_geotech_detail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_sampel_geotech_detail (
    id_l2_daftar_sampel_geotech_detail integer NOT NULL,
    id_l2_daftar_sampel_geotech integer,
    nama_sampel character varying(120) DEFAULT NULL::character varying,
    depth_awal character varying(20),
    depth_akhir character varying(20),
    lithology character varying(20),
    jumlah_sampel smallint,
    bulk_density character varying(20),
    natural_most_content character varying(20),
    platis_limit character varying(20),
    liquid_limit character varying(20),
    sieve character varying(20),
    sf character varying(20),
    ucs character varying(20),
    ds character varying(20),
    bz character varying(20),
    pli character varying(20),
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    tanggal_sample timestamp without time zone
);


ALTER TABLE public.l2_daftar_sampel_geotech_detail OWNER TO postgres;

--
-- Name: l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq OWNER TO postgres;

--
-- Name: l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq OWNED BY public.l2_daftar_sampel_geotech_detail.id_l2_daftar_sampel_geotech_detail;


--
-- Name: l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq OWNER TO postgres;

--
-- Name: l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq OWNED BY public.l2_daftar_sampel_geotech.id_l2_daftar_sampel_geotech;


--
-- Name: l2_daftar_tpa_tpt; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_tpa_tpt (
    id_l2_daftar_tpa_tpt integer NOT NULL,
    username character varying(120) DEFAULT NULL::character varying,
    password character varying(120) DEFAULT NULL::character varying,
    nama character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    nik character varying(20),
    level smallint,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone,
    token integer,
    valid_token timestamp(6) without time zone,
    file_ttd character varying(120),
    jenis_konsultasi smallint DEFAULT 0
);


ALTER TABLE public.l2_daftar_tpa_tpt OWNER TO postgres;

--
-- Name: l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq OWNER TO postgres;

--
-- Name: l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq OWNED BY public.l2_daftar_tpa_tpt.id_l2_daftar_tpa_tpt;


--
-- Name: l2_daftar_undangan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_undangan (
    id_l2_daftar_undangan integer NOT NULL,
    no_registrasi character varying(120) DEFAULT NULL::character varying,
    nama character varying(120) DEFAULT NULL::character varying,
    tanggal_undangan timestamp(6) without time zone,
    no_undangan character varying(120) DEFAULT NULL::character varying,
    tanggal_konsultasi timestamp(6) without time zone,
    hari character varying(20),
    jam character varying(10),
    id_l2_daftar_tpa_tpt_1 integer,
    id_l2_daftar_tpa_tpt_2 integer,
    id_l2_daftar_tpa_tpt_3 integer,
    id_l2_daftar_tpa_tpt_4 integer,
    id_l2_daftar_tpa_tpt_5 integer,
    status integer,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone,
    no_hp character varying(20),
    id_l2_verifikasi2 integer,
    tempat character varying(240),
    link_google_drive character varying(120),
    file_pdf character varying(120),
    jenis_undangan smallint DEFAULT 0,
    link_undangan character varying(240)
);


ALTER TABLE public.l2_daftar_undangan OWNER TO postgres;

--
-- Name: l2_daftar_undangan_id_l2_daftar_undangan_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_undangan_id_l2_daftar_undangan_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_undangan_id_l2_daftar_undangan_seq OWNER TO postgres;

--
-- Name: l2_daftar_undangan_id_l2_daftar_undangan_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_undangan_id_l2_daftar_undangan_seq OWNED BY public.l2_daftar_undangan.id_l2_daftar_undangan;


--
-- Name: l2_daftar_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_daftar_user (
    id_l2_daftar_user integer NOT NULL,
    username character varying(120) DEFAULT NULL::character varying,
    password character varying(120) DEFAULT NULL::character varying,
    nama character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    nik character varying(20),
    level smallint,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone
);


ALTER TABLE public.l2_daftar_user OWNER TO postgres;

--
-- Name: l2_daftar_user_id_l2_daftar_user_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_daftar_user_id_l2_daftar_user_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_daftar_user_id_l2_daftar_user_seq OWNER TO postgres;

--
-- Name: l2_daftar_user_id_l2_daftar_user_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_daftar_user_id_l2_daftar_user_seq OWNED BY public.l2_daftar_user.id_l2_daftar_user;


--
-- Name: l2_daftar_user_tpa_tpt; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.l2_daftar_user_tpa_tpt AS
 SELECT xxx.id_l2_daftar_admin,
    xxx.username,
    xxx.password,
    xxx.nama,
    xxx.no_hp,
    xxx.nik,
    xxx.level,
    xxx.status,
    xxx.token,
    xxx.valid_token,
    xxx.status_admin
   FROM ( SELECT t1.id_l2_daftar_admin,
            t1.username,
            t1.password,
            t1.nama,
            t1.no_hp,
            t1.nik,
            t1.level,
            t1.status,
            t1.token,
            t1.valid_token,
            1 AS status_admin
           FROM public.l2_daftar_admin t1
          WHERE (t1.status = 1)
        UNION
         SELECT t2.id_l2_daftar_tpa_tpt,
            t2.username,
            t2.password,
            t2.nama,
            t2.no_hp,
            t2.nik,
            t2.level,
            t2.status,
            t2.token,
            t2.valid_token,
            0 AS status_admin
           FROM public.l2_daftar_tpa_tpt t2
          WHERE (t2.status = 1)) xxx;


ALTER TABLE public.l2_daftar_user_tpa_tpt OWNER TO postgres;

--
-- Name: l2_kategori_penawaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_kategori_penawaran (
    id_l2_kategori_penawaran integer NOT NULL,
    nama character varying(120) DEFAULT NULL::character varying,
    output character varying(60),
    standard character varying(60),
    qty smallint,
    rates integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan smallint,
    jenis_pengujian smallint
);


ALTER TABLE public.l2_kategori_penawaran OWNER TO postgres;

--
-- Name: l2_kategori_penawaran_id_l2_kategori_penawaran_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_kategori_penawaran_id_l2_kategori_penawaran_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_kategori_penawaran_id_l2_kategori_penawaran_seq OWNER TO postgres;

--
-- Name: l2_kategori_penawaran_id_l2_kategori_penawaran_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_kategori_penawaran_id_l2_kategori_penawaran_seq OWNED BY public.l2_kategori_penawaran.id_l2_kategori_penawaran;


--
-- Name: l2_kategori_penawaran_lingkungan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_kategori_penawaran_lingkungan (
    id_l2_kategori_penawaran_lingkungan integer NOT NULL,
    nama character varying(120) DEFAULT NULL::character varying,
    satuan character varying(60),
    volume integer,
    harga integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan smallint,
    jenis_pengujian smallint
);


ALTER TABLE public.l2_kategori_penawaran_lingkungan OWNER TO postgres;

--
-- Name: l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq OWNER TO postgres;

--
-- Name: l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq OWNED BY public.l2_kategori_penawaran_lingkungan.id_l2_kategori_penawaran_lingkungan;


--
-- Name: l2_kirim_pricelist; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_kirim_pricelist (
    id_l2_kirim_pricelist integer NOT NULL,
    nama character varying(120) DEFAULT NULL::character varying,
    inisial character varying(20),
    cp character varying(120) DEFAULT NULL::character varying,
    no_hp character varying(20),
    alamat character varying(240) DEFAULT NULL::character varying,
    file_pdf character varying(120),
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone,
    jenis_pengujian smallint,
    status_persetujuan smallint DEFAULT 0,
    status_kirim_wa smallint DEFAULT 0,
    tanggal_kirim_wa timestamp without time zone,
    status_kirim_email character varying DEFAULT '0'::character varying,
    tanggal_kirim_email timestamp without time zone
);


ALTER TABLE public.l2_kirim_pricelist OWNER TO postgres;

--
-- Name: l2_kirim_pricelist_id_kirim_pricelist_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_kirim_pricelist_id_kirim_pricelist_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_kirim_pricelist_id_kirim_pricelist_seq OWNER TO postgres;

--
-- Name: l2_kirim_pricelist_id_kirim_pricelist_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_kirim_pricelist_id_kirim_pricelist_seq OWNED BY public.l2_kirim_pricelist.id_l2_kirim_pricelist;


--
-- Name: l2_level_user; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_level_user (
    id_l2_level_user integer NOT NULL,
    nama_level character varying(120) DEFAULT NULL::character varying,
    kode_level character varying(20),
    level smallint,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone
);


ALTER TABLE public.l2_level_user OWNER TO postgres;

--
-- Name: l2_level_user_id_l2_level_user_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_level_user_id_l2_level_user_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_level_user_id_l2_level_user_seq OWNER TO postgres;

--
-- Name: l2_level_user_id_l2_level_user_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_level_user_id_l2_level_user_seq OWNED BY public.l2_level_user.id_l2_level_user;


--
-- Name: l2_no_urut_kode; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_no_urut_kode (
    id_l2_no_urut_kode integer NOT NULL,
    nama character varying(60) DEFAULT NULL::character varying,
    kode character varying(20),
    no_terakhir integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone
);


ALTER TABLE public.l2_no_urut_kode OWNER TO postgres;

--
-- Name: l2_no_urut_kode_id_l2_no_urut_kode_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_no_urut_kode_id_l2_no_urut_kode_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_no_urut_kode_id_l2_no_urut_kode_seq OWNER TO postgres;

--
-- Name: l2_no_urut_kode_id_l2_no_urut_kode_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_no_urut_kode_id_l2_no_urut_kode_seq OWNED BY public.l2_no_urut_kode.id_l2_no_urut_kode;


--
-- Name: l2_no_urut_surat; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_no_urut_surat (
    id_l2_no_urut_surat integer NOT NULL,
    jenis_surat character varying(60) DEFAULT NULL::character varying,
    kode_surat character varying(20),
    format_no_urut_surat character varying(120) DEFAULT NULL::character varying,
    no_terakhir integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone
);


ALTER TABLE public.l2_no_urut_surat OWNER TO postgres;

--
-- Name: l2_no_urut_surat_id_l2_no_urut_surat_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_no_urut_surat_id_l2_no_urut_surat_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_no_urut_surat_id_l2_no_urut_surat_seq OWNER TO postgres;

--
-- Name: l2_no_urut_surat_id_l2_no_urut_surat_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_no_urut_surat_id_l2_no_urut_surat_seq OWNED BY public.l2_no_urut_surat.id_l2_no_urut_surat;


--
-- Name: l2_parameter_retribusi; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_parameter_retribusi (
    id_l2_parameter_retribusi integer NOT NULL,
    kode character varying(20),
    nama character varying(120) DEFAULT NULL::character varying,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone
);


ALTER TABLE public.l2_parameter_retribusi OWNER TO postgres;

--
-- Name: l2_parameter_retribusi_detail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_parameter_retribusi_detail (
    id_l2_parameter_retribusi_detail integer NOT NULL,
    id_l2_parameter_retribusi integer DEFAULT 0,
    nama character varying(120) DEFAULT NULL::character varying,
    nilai real DEFAULT 0,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone
);


ALTER TABLE public.l2_parameter_retribusi_detail OWNER TO postgres;

--
-- Name: l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq OWNER TO postgres;

--
-- Name: l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq OWNED BY public.l2_parameter_retribusi_detail.id_l2_parameter_retribusi_detail;


--
-- Name: l2_parameter_retribusi_id_l2_parameter_retribusi_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_parameter_retribusi_id_l2_parameter_retribusi_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_parameter_retribusi_id_l2_parameter_retribusi_seq OWNER TO postgres;

--
-- Name: l2_parameter_retribusi_id_l2_parameter_retribusi_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_parameter_retribusi_id_l2_parameter_retribusi_seq OWNED BY public.l2_parameter_retribusi.id_l2_parameter_retribusi;


--
-- Name: l2_setting_server; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_setting_server (
    id_l2_setting_server integer NOT NULL,
    alamat_server character varying(120) DEFAULT NULL::character varying,
    no_wa character varying(20),
    token_wa character varying(120) DEFAULT NULL::character varying,
    email character varying(120) DEFAULT NULL::character varying,
    password character varying(120) DEFAULT NULL::character varying,
    smtp character varying(120) DEFAULT NULL::character varying,
    port character varying(20),
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying,
    nama_user_validasi character varying(60),
    tanggal_update timestamp(6) without time zone
);


ALTER TABLE public.l2_setting_server OWNER TO postgres;

--
-- Name: l2_setting_server_id_l2_setting_server_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_setting_server_id_l2_setting_server_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_setting_server_id_l2_setting_server_seq OWNER TO postgres;

--
-- Name: l2_setting_server_id_l2_setting_server_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_setting_server_id_l2_setting_server_seq OWNED BY public.l2_setting_server.id_l2_setting_server;


--
-- Name: l2_sub_kategori_penawaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_sub_kategori_penawaran (
    id_l2_sub_kategori_penawaran integer NOT NULL,
    id_l2_kategori_penawaran integer,
    nama character varying(120) DEFAULT NULL::character varying,
    output character varying(60),
    standard character varying(60),
    qty smallint,
    rates integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan smallint,
    file_symbol character varying(120)
);


ALTER TABLE public.l2_sub_kategori_penawaran OWNER TO postgres;

--
-- Name: l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq OWNER TO postgres;

--
-- Name: l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq OWNED BY public.l2_sub_kategori_penawaran.id_l2_sub_kategori_penawaran;


--
-- Name: l2_sub_kategori_penawaran_lingkungan; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_sub_kategori_penawaran_lingkungan (
    id_l2_sub_kategori_penawaran_lingkungan integer NOT NULL,
    id_l2_kategori_penawaran_lingkungan integer,
    nama character varying(320) DEFAULT NULL::character varying,
    satuan character varying(60),
    volume integer,
    harga integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan smallint,
    jenis_pengujian smallint,
    file_symbol character varying(120)
);


ALTER TABLE public.l2_sub_kategori_penawaran_lingkungan OWNER TO postgres;

--
-- Name: l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq OWNER TO postgres;

--
-- Name: l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq OWNED BY public.l2_sub_kategori_penawaran_lingkungan.id_l2_sub_kategori_penawaran_lingkungan;


--
-- Name: l2_sub_sub_kategori_penawaran; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.l2_sub_sub_kategori_penawaran (
    id_l2_sub_sub_kategori_penawaran integer NOT NULL,
    id_l2_kategori_penawaran integer,
    id_l2_sub_kategori_penawaran integer,
    nama character varying(120) DEFAULT NULL::character varying,
    output character varying(60),
    standard character varying(60),
    qty smallint,
    rates integer,
    status smallint,
    tanggal_input timestamp(6) without time zone,
    user_validasi character varying(120),
    nama_user_validasi character varying(120),
    tanggal_update timestamp without time zone,
    urutan smallint,
    file_symbol character varying(120)
);


ALTER TABLE public.l2_sub_sub_kategori_penawaran OWNER TO postgres;

--
-- Name: l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq OWNER TO postgres;

--
-- Name: l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq OWNED BY public.l2_sub_sub_kategori_penawaran.id_l2_sub_sub_kategori_penawaran;


--
-- Name: master_migrasi_id_master_migrasi_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.master_migrasi_id_master_migrasi_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.master_migrasi_id_master_migrasi_seq OWNER TO postgres;

--
-- Name: l2_barcode id_l2_barcode; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_barcode ALTER COLUMN id_l2_barcode SET DEFAULT nextval('public.l2_barcode_id_l2_barcode_seq'::regclass);


--
-- Name: l2_daftar_admin id_l2_daftar_admin; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_admin ALTER COLUMN id_l2_daftar_admin SET DEFAULT nextval('public.l2_daftar_admin_id_l2_daftar_admin_seq'::regclass);


--
-- Name: l2_daftar_customer id_l2_daftar_customer; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_customer ALTER COLUMN id_l2_daftar_customer SET DEFAULT nextval('public.l2_daftar_customer_id_l2_daftar_customer_seq'::regclass);


--
-- Name: l2_daftar_penawaran id_l2_daftar_penawaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran ALTER COLUMN id_l2_daftar_penawaran SET DEFAULT nextval('public.l2_daftar_penawaran_id_l2_daftar_penawaran_seq'::regclass);


--
-- Name: l2_daftar_penawaran_detail l2_daftar_penawaran_detail; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran_detail ALTER COLUMN l2_daftar_penawaran_detail SET DEFAULT nextval('public.l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq'::regclass);


--
-- Name: l2_daftar_penawaran_lingkungan id_l2_daftar_penawaran_lingkungan; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran_lingkungan ALTER COLUMN id_l2_daftar_penawaran_lingkungan SET DEFAULT nextval('public.l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq'::regclass);


--
-- Name: l2_daftar_penawaran_lingkungan_detail l2_daftar_penawaran_lingkungan_detail; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran_lingkungan_detail ALTER COLUMN l2_daftar_penawaran_lingkungan_detail SET DEFAULT nextval('public.l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq'::regclass);


--
-- Name: l2_daftar_sampel_geotech id_l2_daftar_sampel_geotech; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_sampel_geotech ALTER COLUMN id_l2_daftar_sampel_geotech SET DEFAULT nextval('public.l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq'::regclass);


--
-- Name: l2_daftar_sampel_geotech_detail id_l2_daftar_sampel_geotech_detail; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_sampel_geotech_detail ALTER COLUMN id_l2_daftar_sampel_geotech_detail SET DEFAULT nextval('public.l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq'::regclass);


--
-- Name: l2_daftar_tpa_tpt id_l2_daftar_tpa_tpt; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_tpa_tpt ALTER COLUMN id_l2_daftar_tpa_tpt SET DEFAULT nextval('public.l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq'::regclass);


--
-- Name: l2_daftar_undangan id_l2_daftar_undangan; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_undangan ALTER COLUMN id_l2_daftar_undangan SET DEFAULT nextval('public.l2_daftar_undangan_id_l2_daftar_undangan_seq'::regclass);


--
-- Name: l2_daftar_user id_l2_daftar_user; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_user ALTER COLUMN id_l2_daftar_user SET DEFAULT nextval('public.l2_daftar_user_id_l2_daftar_user_seq'::regclass);


--
-- Name: l2_kategori_penawaran id_l2_kategori_penawaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_kategori_penawaran ALTER COLUMN id_l2_kategori_penawaran SET DEFAULT nextval('public.l2_kategori_penawaran_id_l2_kategori_penawaran_seq'::regclass);


--
-- Name: l2_kategori_penawaran_lingkungan id_l2_kategori_penawaran_lingkungan; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_kategori_penawaran_lingkungan ALTER COLUMN id_l2_kategori_penawaran_lingkungan SET DEFAULT nextval('public.l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq'::regclass);


--
-- Name: l2_kirim_pricelist id_l2_kirim_pricelist; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_kirim_pricelist ALTER COLUMN id_l2_kirim_pricelist SET DEFAULT nextval('public.l2_kirim_pricelist_id_kirim_pricelist_seq'::regclass);


--
-- Name: l2_level_user id_l2_level_user; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_level_user ALTER COLUMN id_l2_level_user SET DEFAULT nextval('public.l2_level_user_id_l2_level_user_seq'::regclass);


--
-- Name: l2_no_urut_kode id_l2_no_urut_kode; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_no_urut_kode ALTER COLUMN id_l2_no_urut_kode SET DEFAULT nextval('public.l2_no_urut_kode_id_l2_no_urut_kode_seq'::regclass);


--
-- Name: l2_no_urut_surat id_l2_no_urut_surat; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_no_urut_surat ALTER COLUMN id_l2_no_urut_surat SET DEFAULT nextval('public.l2_no_urut_surat_id_l2_no_urut_surat_seq'::regclass);


--
-- Name: l2_parameter_retribusi id_l2_parameter_retribusi; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_parameter_retribusi ALTER COLUMN id_l2_parameter_retribusi SET DEFAULT nextval('public.l2_parameter_retribusi_id_l2_parameter_retribusi_seq'::regclass);


--
-- Name: l2_parameter_retribusi_detail id_l2_parameter_retribusi_detail; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_parameter_retribusi_detail ALTER COLUMN id_l2_parameter_retribusi_detail SET DEFAULT nextval('public.l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq'::regclass);


--
-- Name: l2_setting_server id_l2_setting_server; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_setting_server ALTER COLUMN id_l2_setting_server SET DEFAULT nextval('public.l2_setting_server_id_l2_setting_server_seq'::regclass);


--
-- Name: l2_sub_kategori_penawaran id_l2_sub_kategori_penawaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_sub_kategori_penawaran ALTER COLUMN id_l2_sub_kategori_penawaran SET DEFAULT nextval('public.l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq'::regclass);


--
-- Name: l2_sub_kategori_penawaran_lingkungan id_l2_sub_kategori_penawaran_lingkungan; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_sub_kategori_penawaran_lingkungan ALTER COLUMN id_l2_sub_kategori_penawaran_lingkungan SET DEFAULT nextval('public.l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq'::regclass);


--
-- Name: l2_sub_sub_kategori_penawaran id_l2_sub_sub_kategori_penawaran; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_sub_sub_kategori_penawaran ALTER COLUMN id_l2_sub_sub_kategori_penawaran SET DEFAULT nextval('public.l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq'::regclass);


--
-- Data for Name: l2_barcode; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_barcode (id_l2_barcode, id_l2_daftar_sampel_geotech, barcode, nomor_dokumen, nomor_wo, tanggal_input, user_validasi, nama_user_validasi) FROM stdin;
\.
COPY public.l2_barcode (id_l2_barcode, id_l2_daftar_sampel_geotech, barcode, nomor_dokumen, nomor_wo, tanggal_input, user_validasi, nama_user_validasi) FROM '$$PATH$$/3635.dat';

--
-- Data for Name: l2_daftar_admin; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_admin (id_l2_daftar_admin, username, password, nama, no_hp, nik, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, token, valid_token, file_ttd, jenis_pengujian, pemberi_persetujuan, jabatan, departemen, lokasi_kerja) FROM stdin;
\.
COPY public.l2_daftar_admin (id_l2_daftar_admin, username, password, nama, no_hp, nik, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, token, valid_token, file_ttd, jenis_pengujian, pemberi_persetujuan, jabatan, departemen, lokasi_kerja) FROM '$$PATH$$/3587.dat';

--
-- Data for Name: l2_daftar_customer; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_customer (id_l2_daftar_customer, username, password, nama, inisial, cp, no_hp, alamat, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, token, valid_token) FROM stdin;
\.
COPY public.l2_daftar_customer (id_l2_daftar_customer, username, password, nama, inisial, cp, no_hp, alamat, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, token, valid_token) FROM '$$PATH$$/3589.dat';

--
-- Data for Name: l2_daftar_penawaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_penawaran (id_l2_daftar_penawaran, id_l2_daftar_customer, nomor_surat, tanggal_penawaran, nama, inisial, cp, no_hp, alamat, jenis_pengujian, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, sum_banyak, sum_total, file_pdf, revisi, no_urut_surat, status_persetujuan, diskon, harga_final, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email) FROM stdin;
\.
COPY public.l2_daftar_penawaran (id_l2_daftar_penawaran, id_l2_daftar_customer, nomor_surat, tanggal_penawaran, nama, inisial, cp, no_hp, alamat, jenis_pengujian, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, sum_banyak, sum_total, file_pdf, revisi, no_urut_surat, status_persetujuan, diskon, harga_final, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email) FROM '$$PATH$$/3591.dat';

--
-- Data for Name: l2_daftar_penawaran_detail; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_penawaran_detail (l2_daftar_penawaran_detail, id_l2_daftar_penawaran, id_l2_kategori_penawaran, id_l2_sub_kategori_penawaran, id_l2_sub_sub_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, banyak, sub_total, file_symbol) FROM stdin;
\.
COPY public.l2_daftar_penawaran_detail (l2_daftar_penawaran_detail, id_l2_daftar_penawaran, id_l2_kategori_penawaran, id_l2_sub_kategori_penawaran, id_l2_sub_sub_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, banyak, sub_total, file_symbol) FROM '$$PATH$$/3592.dat';

--
-- Data for Name: l2_daftar_penawaran_lingkungan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_penawaran_lingkungan (id_l2_daftar_penawaran_lingkungan, id_l2_daftar_customer, nomor_surat, tanggal_penawaran, nama, inisial, cp, no_hp, alamat, jenis_pengujian, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, sum_banyak, sum_total, file_pdf, revisi, no_urut_surat, status_persetujuan, diskon, harga_final, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email) FROM stdin;
\.
COPY public.l2_daftar_penawaran_lingkungan (id_l2_daftar_penawaran_lingkungan, id_l2_daftar_customer, nomor_surat, tanggal_penawaran, nama, inisial, cp, no_hp, alamat, jenis_pengujian, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, sum_banyak, sum_total, file_pdf, revisi, no_urut_surat, status_persetujuan, diskon, harga_final, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email) FROM '$$PATH$$/3595.dat';

--
-- Data for Name: l2_daftar_penawaran_lingkungan_detail; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_penawaran_lingkungan_detail (l2_daftar_penawaran_lingkungan_detail, id_l2_daftar_penawaran_lingkungan, id_l2_kategori_penawaran_lingkungan, id_l2_sub_kategori_penawaran_lingkungan, id_l2_sub_sub_kategori_penawaran_lingkungan, nama, output, satuan, volume, harga, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, banyak, sub_total, file_symbol) FROM stdin;
\.
COPY public.l2_daftar_penawaran_lingkungan_detail (l2_daftar_penawaran_lingkungan_detail, id_l2_daftar_penawaran_lingkungan, id_l2_kategori_penawaran_lingkungan, id_l2_sub_kategori_penawaran_lingkungan, id_l2_sub_sub_kategori_penawaran_lingkungan, nama, output, satuan, volume, harga, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, banyak, sub_total, file_symbol) FROM '$$PATH$$/3597.dat';

--
-- Data for Name: l2_daftar_sampel_geotech; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_sampel_geotech (id_l2_daftar_sampel_geotech, barcode, id_l2_daftar_customer, nama, inisial, cp, no_hp, alamat, nomor_dokumen, nomor_wo, revisi, tanggal_berlaku, id_l2_daftar_admin, file_pdf, status_persetujuan, id_l2_daftar_admin_persetujuan, tanggal_persetujuan, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email, file_barcode, no_urut_surat) FROM stdin;
\.
COPY public.l2_daftar_sampel_geotech (id_l2_daftar_sampel_geotech, barcode, id_l2_daftar_customer, nama, inisial, cp, no_hp, alamat, nomor_dokumen, nomor_wo, revisi, tanggal_berlaku, id_l2_daftar_admin, file_pdf, status_persetujuan, id_l2_daftar_admin_persetujuan, tanggal_persetujuan, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email, file_barcode, no_urut_surat) FROM '$$PATH$$/3633.dat';

--
-- Data for Name: l2_daftar_sampel_geotech_detail; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_sampel_geotech_detail (id_l2_daftar_sampel_geotech_detail, id_l2_daftar_sampel_geotech, nama_sampel, depth_awal, depth_akhir, lithology, jumlah_sampel, bulk_density, natural_most_content, platis_limit, liquid_limit, sieve, sf, ucs, ds, bz, pli, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, tanggal_sample) FROM stdin;
\.
COPY public.l2_daftar_sampel_geotech_detail (id_l2_daftar_sampel_geotech_detail, id_l2_daftar_sampel_geotech, nama_sampel, depth_awal, depth_akhir, lithology, jumlah_sampel, bulk_density, natural_most_content, platis_limit, liquid_limit, sieve, sf, ucs, ds, bz, pli, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, tanggal_sample) FROM '$$PATH$$/3599.dat';

--
-- Data for Name: l2_daftar_tpa_tpt; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_tpa_tpt (id_l2_daftar_tpa_tpt, username, password, nama, no_hp, nik, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, token, valid_token, file_ttd, jenis_konsultasi) FROM stdin;
\.
COPY public.l2_daftar_tpa_tpt (id_l2_daftar_tpa_tpt, username, password, nama, no_hp, nik, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, token, valid_token, file_ttd, jenis_konsultasi) FROM '$$PATH$$/3601.dat';

--
-- Data for Name: l2_daftar_undangan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_undangan (id_l2_daftar_undangan, no_registrasi, nama, tanggal_undangan, no_undangan, tanggal_konsultasi, hari, jam, id_l2_daftar_tpa_tpt_1, id_l2_daftar_tpa_tpt_2, id_l2_daftar_tpa_tpt_3, id_l2_daftar_tpa_tpt_4, id_l2_daftar_tpa_tpt_5, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, no_hp, id_l2_verifikasi2, tempat, link_google_drive, file_pdf, jenis_undangan, link_undangan) FROM stdin;
\.
COPY public.l2_daftar_undangan (id_l2_daftar_undangan, no_registrasi, nama, tanggal_undangan, no_undangan, tanggal_konsultasi, hari, jam, id_l2_daftar_tpa_tpt_1, id_l2_daftar_tpa_tpt_2, id_l2_daftar_tpa_tpt_3, id_l2_daftar_tpa_tpt_4, id_l2_daftar_tpa_tpt_5, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, no_hp, id_l2_verifikasi2, tempat, link_google_drive, file_pdf, jenis_undangan, link_undangan) FROM '$$PATH$$/3603.dat';

--
-- Data for Name: l2_daftar_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_daftar_user (id_l2_daftar_user, username, password, nama, no_hp, nik, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_daftar_user (id_l2_daftar_user, username, password, nama, no_hp, nik, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3605.dat';

--
-- Data for Name: l2_kategori_penawaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_kategori_penawaran (id_l2_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, jenis_pengujian) FROM stdin;
\.
COPY public.l2_kategori_penawaran (id_l2_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, jenis_pengujian) FROM '$$PATH$$/3607.dat';

--
-- Data for Name: l2_kategori_penawaran_lingkungan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_kategori_penawaran_lingkungan (id_l2_kategori_penawaran_lingkungan, nama, satuan, volume, harga, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, jenis_pengujian) FROM stdin;
\.
COPY public.l2_kategori_penawaran_lingkungan (id_l2_kategori_penawaran_lingkungan, nama, satuan, volume, harga, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, jenis_pengujian) FROM '$$PATH$$/3609.dat';

--
-- Data for Name: l2_kirim_pricelist; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_kirim_pricelist (id_l2_kirim_pricelist, nama, inisial, cp, no_hp, alamat, file_pdf, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, jenis_pengujian, status_persetujuan, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email) FROM stdin;
\.
COPY public.l2_kirim_pricelist (id_l2_kirim_pricelist, nama, inisial, cp, no_hp, alamat, file_pdf, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, jenis_pengujian, status_persetujuan, status_kirim_wa, tanggal_kirim_wa, status_kirim_email, tanggal_kirim_email) FROM '$$PATH$$/3611.dat';

--
-- Data for Name: l2_level_user; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_level_user (id_l2_level_user, nama_level, kode_level, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_level_user (id_l2_level_user, nama_level, kode_level, level, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3613.dat';

--
-- Data for Name: l2_no_urut_kode; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_no_urut_kode (id_l2_no_urut_kode, nama, kode, no_terakhir, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_no_urut_kode (id_l2_no_urut_kode, nama, kode, no_terakhir, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3615.dat';

--
-- Data for Name: l2_no_urut_surat; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_no_urut_surat (id_l2_no_urut_surat, jenis_surat, kode_surat, format_no_urut_surat, no_terakhir, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_no_urut_surat (id_l2_no_urut_surat, jenis_surat, kode_surat, format_no_urut_surat, no_terakhir, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3617.dat';

--
-- Data for Name: l2_parameter_retribusi; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_parameter_retribusi (id_l2_parameter_retribusi, kode, nama, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_parameter_retribusi (id_l2_parameter_retribusi, kode, nama, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3619.dat';

--
-- Data for Name: l2_parameter_retribusi_detail; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_parameter_retribusi_detail (id_l2_parameter_retribusi_detail, id_l2_parameter_retribusi, nama, nilai, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_parameter_retribusi_detail (id_l2_parameter_retribusi_detail, id_l2_parameter_retribusi, nama, nilai, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3620.dat';

--
-- Data for Name: l2_setting_server; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_setting_server (id_l2_setting_server, alamat_server, no_wa, token_wa, email, password, smtp, port, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM stdin;
\.
COPY public.l2_setting_server (id_l2_setting_server, alamat_server, no_wa, token_wa, email, password, smtp, port, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update) FROM '$$PATH$$/3623.dat';

--
-- Data for Name: l2_sub_kategori_penawaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_sub_kategori_penawaran (id_l2_sub_kategori_penawaran, id_l2_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, file_symbol) FROM stdin;
\.
COPY public.l2_sub_kategori_penawaran (id_l2_sub_kategori_penawaran, id_l2_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, file_symbol) FROM '$$PATH$$/3625.dat';

--
-- Data for Name: l2_sub_kategori_penawaran_lingkungan; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_sub_kategori_penawaran_lingkungan (id_l2_sub_kategori_penawaran_lingkungan, id_l2_kategori_penawaran_lingkungan, nama, satuan, volume, harga, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, jenis_pengujian, file_symbol) FROM stdin;
\.
COPY public.l2_sub_kategori_penawaran_lingkungan (id_l2_sub_kategori_penawaran_lingkungan, id_l2_kategori_penawaran_lingkungan, nama, satuan, volume, harga, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, jenis_pengujian, file_symbol) FROM '$$PATH$$/3627.dat';

--
-- Data for Name: l2_sub_sub_kategori_penawaran; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.l2_sub_sub_kategori_penawaran (id_l2_sub_sub_kategori_penawaran, id_l2_kategori_penawaran, id_l2_sub_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, file_symbol) FROM stdin;
\.
COPY public.l2_sub_sub_kategori_penawaran (id_l2_sub_sub_kategori_penawaran, id_l2_kategori_penawaran, id_l2_sub_kategori_penawaran, nama, output, standard, qty, rates, status, tanggal_input, user_validasi, nama_user_validasi, tanggal_update, urutan, file_symbol) FROM '$$PATH$$/3629.dat';

--
-- Name: daftar_peserta_selter_sekda_lamp_id_daftar_peserta_selter_sekda; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.daftar_peserta_selter_sekda_lamp_id_daftar_peserta_selter_sekda', 21, true);


--
-- Name: l2_barcode_id_l2_barcode_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_barcode_id_l2_barcode_seq', 39, true);


--
-- Name: l2_daftar_admin_id_l2_daftar_admin_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_admin_id_l2_daftar_admin_seq', 24, true);


--
-- Name: l2_daftar_customer_id_l2_daftar_customer_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_customer_id_l2_daftar_customer_seq', 2, true);


--
-- Name: l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_penawaran_detail_l2_daftar_penawaran_detail_seq', 1992, true);


--
-- Name: l2_daftar_penawaran_id_l2_daftar_penawaran_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_penawaran_id_l2_daftar_penawaran_seq', 59, true);


--
-- Name: l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_penawaran_lingkunga_id_l2_daftar_penawaran_lingku_seq', 15, true);


--
-- Name: l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_penawaran_lingkunga_l2_daftar_penawaran_lingkunga_seq', 633, true);


--
-- Name: l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_sampel_geotech_deta_id_l2_daftar_sampel_geotech_d_seq', 210, true);


--
-- Name: l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_sampel_geotech_id_l2_daftar_sampel_geotech_seq', 37, true);


--
-- Name: l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_tpa_tpt_id_l2_daftar_tpa_tpt_seq', 6, true);


--
-- Name: l2_daftar_undangan_id_l2_daftar_undangan_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_undangan_id_l2_daftar_undangan_seq', 8, true);


--
-- Name: l2_daftar_user_id_l2_daftar_user_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_daftar_user_id_l2_daftar_user_seq', 1, false);


--
-- Name: l2_kategori_penawaran_id_l2_kategori_penawaran_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_kategori_penawaran_id_l2_kategori_penawaran_seq', 6, true);


--
-- Name: l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_kategori_penawaran_lingkun_id_l2_kategori_penawaran_ling_seq', 27, true);


--
-- Name: l2_kirim_pricelist_id_kirim_pricelist_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_kirim_pricelist_id_kirim_pricelist_seq', 6, true);


--
-- Name: l2_level_user_id_l2_level_user_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_level_user_id_l2_level_user_seq', 10, true);


--
-- Name: l2_no_urut_kode_id_l2_no_urut_kode_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_no_urut_kode_id_l2_no_urut_kode_seq', 11, true);


--
-- Name: l2_no_urut_surat_id_l2_no_urut_surat_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_no_urut_surat_id_l2_no_urut_surat_seq', 9, true);


--
-- Name: l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_parameter_retribusi_detail_id_l2_parameter_retribusi_det_seq', 38, true);


--
-- Name: l2_parameter_retribusi_id_l2_parameter_retribusi_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_parameter_retribusi_id_l2_parameter_retribusi_seq', 10, true);


--
-- Name: l2_setting_server_id_l2_setting_server_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_setting_server_id_l2_setting_server_seq', 3, true);


--
-- Name: l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_sub_kategori_penawaran_id_l2_sub_kategori_penawaran_seq', 21, true);


--
-- Name: l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_sub_kategori_penawaran_lin_id_l2_sub_kategori_penawaran__seq', 21, true);


--
-- Name: l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.l2_sub_sub_kategori_penawaran_id_l2_sub_sub_kategori_penawa_seq', 10, true);


--
-- Name: master_migrasi_id_master_migrasi_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.master_migrasi_id_master_migrasi_seq', 1, false);


--
-- Name: l2_kirim_pricelist id_kirim_pricelist_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_kirim_pricelist
    ADD CONSTRAINT id_kirim_pricelist_pkey PRIMARY KEY (id_l2_kirim_pricelist);


--
-- Name: l2_barcode id_l2_barcode_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_barcode
    ADD CONSTRAINT id_l2_barcode_pkey PRIMARY KEY (id_l2_barcode);


--
-- Name: l2_daftar_admin id_l2_daftar_admin_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_admin
    ADD CONSTRAINT id_l2_daftar_admin_pkey PRIMARY KEY (id_l2_daftar_admin);


--
-- Name: l2_daftar_customer id_l2_daftar_customer_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_customer
    ADD CONSTRAINT id_l2_daftar_customer_pkey PRIMARY KEY (id_l2_daftar_customer);


--
-- Name: l2_daftar_penawaran_lingkungan id_l2_daftar_penawaran_lingkungan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran_lingkungan
    ADD CONSTRAINT id_l2_daftar_penawaran_lingkungan_pkey PRIMARY KEY (id_l2_daftar_penawaran_lingkungan);


--
-- Name: l2_daftar_penawaran id_l2_daftar_penawaran_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran
    ADD CONSTRAINT id_l2_daftar_penawaran_pkey PRIMARY KEY (id_l2_daftar_penawaran);


--
-- Name: l2_daftar_sampel_geotech_detail id_l2_daftar_sampel_geotech_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_sampel_geotech_detail
    ADD CONSTRAINT id_l2_daftar_sampel_geotech_detail_pkey PRIMARY KEY (id_l2_daftar_sampel_geotech_detail);


--
-- Name: l2_daftar_sampel_geotech id_l2_daftar_sampel_geotech_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_sampel_geotech
    ADD CONSTRAINT id_l2_daftar_sampel_geotech_pkey PRIMARY KEY (id_l2_daftar_sampel_geotech);


--
-- Name: l2_daftar_tpa_tpt id_l2_daftar_tpa_tpt_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_tpa_tpt
    ADD CONSTRAINT id_l2_daftar_tpa_tpt_pkey PRIMARY KEY (id_l2_daftar_tpa_tpt);


--
-- Name: l2_daftar_undangan id_l2_daftar_undangan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_undangan
    ADD CONSTRAINT id_l2_daftar_undangan_pkey PRIMARY KEY (id_l2_daftar_undangan);


--
-- Name: l2_daftar_user id_l2_daftar_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_user
    ADD CONSTRAINT id_l2_daftar_user_pkey PRIMARY KEY (id_l2_daftar_user);


--
-- Name: l2_kategori_penawaran_lingkungan id_l2_kategori_penawaran_lingkungan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_kategori_penawaran_lingkungan
    ADD CONSTRAINT id_l2_kategori_penawaran_lingkungan_pkey PRIMARY KEY (id_l2_kategori_penawaran_lingkungan);


--
-- Name: l2_kategori_penawaran id_l2_kategori_penawaran_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_kategori_penawaran
    ADD CONSTRAINT id_l2_kategori_penawaran_pkey PRIMARY KEY (id_l2_kategori_penawaran);


--
-- Name: l2_level_user id_l2_level_user_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_level_user
    ADD CONSTRAINT id_l2_level_user_pkey PRIMARY KEY (id_l2_level_user);


--
-- Name: l2_no_urut_kode id_l2_no_urut_kode_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_no_urut_kode
    ADD CONSTRAINT id_l2_no_urut_kode_pkey PRIMARY KEY (id_l2_no_urut_kode);


--
-- Name: l2_no_urut_surat id_l2_no_urut_surat_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_no_urut_surat
    ADD CONSTRAINT id_l2_no_urut_surat_pkey PRIMARY KEY (id_l2_no_urut_surat);


--
-- Name: l2_parameter_retribusi_detail id_l2_parameter_retribusi_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_parameter_retribusi_detail
    ADD CONSTRAINT id_l2_parameter_retribusi_detail_pkey PRIMARY KEY (id_l2_parameter_retribusi_detail);


--
-- Name: l2_parameter_retribusi id_l2_parameter_retribusi_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_parameter_retribusi
    ADD CONSTRAINT id_l2_parameter_retribusi_pkey PRIMARY KEY (id_l2_parameter_retribusi);


--
-- Name: l2_setting_server id_l2_setting_server_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_setting_server
    ADD CONSTRAINT id_l2_setting_server_pkey PRIMARY KEY (id_l2_setting_server);


--
-- Name: l2_sub_kategori_penawaran_lingkungan id_l2_sub_kategori_penawaran_lingkungan_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_sub_kategori_penawaran_lingkungan
    ADD CONSTRAINT id_l2_sub_kategori_penawaran_lingkungan_pkey PRIMARY KEY (id_l2_sub_kategori_penawaran_lingkungan);


--
-- Name: l2_sub_kategori_penawaran id_l2_sub_kategori_penawaran_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_sub_kategori_penawaran
    ADD CONSTRAINT id_l2_sub_kategori_penawaran_pkey PRIMARY KEY (id_l2_sub_kategori_penawaran);


--
-- Name: l2_sub_sub_kategori_penawaran id_l2_sub_sub_kategori_penawaran_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_sub_sub_kategori_penawaran
    ADD CONSTRAINT id_l2_sub_sub_kategori_penawaran_pkey PRIMARY KEY (id_l2_sub_sub_kategori_penawaran);


--
-- Name: l2_daftar_admin l2_daftar_admin_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_admin
    ADD CONSTRAINT l2_daftar_admin_unique UNIQUE (username);


--
-- Name: l2_daftar_admin l2_daftar_admin_unique_1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_admin
    ADD CONSTRAINT l2_daftar_admin_unique_1 UNIQUE (no_hp);


--
-- Name: l2_daftar_customer l2_daftar_customer_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_customer
    ADD CONSTRAINT l2_daftar_customer_unique UNIQUE (username);


--
-- Name: l2_daftar_customer l2_daftar_customer_unique_1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_customer
    ADD CONSTRAINT l2_daftar_customer_unique_1 UNIQUE (no_hp);


--
-- Name: l2_daftar_penawaran_detail l2_daftar_penawaran_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran_detail
    ADD CONSTRAINT l2_daftar_penawaran_detail_pkey PRIMARY KEY (l2_daftar_penawaran_detail);


--
-- Name: l2_daftar_penawaran_lingkungan_detail l2_daftar_penawaran_lingkungan_detail_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_daftar_penawaran_lingkungan_detail
    ADD CONSTRAINT l2_daftar_penawaran_lingkungan_detail_pkey PRIMARY KEY (l2_daftar_penawaran_lingkungan_detail);


--
-- Name: l2_level_user l2_level_user_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_level_user
    ADD CONSTRAINT l2_level_user_unique UNIQUE (kode_level);


--
-- Name: l2_level_user l2_level_user_unique_1; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_level_user
    ADD CONSTRAINT l2_level_user_unique_1 UNIQUE (level);


--
-- Name: l2_no_urut_kode l2_no_urut_kode_unique; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.l2_no_urut_kode
    ADD CONSTRAINT l2_no_urut_kode_unique UNIQUE (kode);


--
-- PostgreSQL database dump complete
--

