<?php
/**
 * PHPExcel
 *
 * Copyright (c) 2006 - 2015 PHPExcel
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category   PHPExcel
 * @package    PHPExcel
 * @copyright  Copyright (c) 2006 - 2015 PHPExcel (http://www.codeplex.com/PHPExcel)
 * @license    http://www.gnu.org/licenses/old-licenses/lgpl-2.1.txt	LGPL
 * @version    ##VERSION##, ##DATE##
 */

/** Error reporting */
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);

define('EOL',(PHP_SAPI == 'cli') ? PHP_EOL : '<br />');

date_default_timezone_set('Europe/London');

/** PHPExcel_IOFactory */
require_once dirname(__FILE__) . '/../Classes/PHPExcel/IOFactory.php';



//echo date('H:i:s') , " Load from Excel5 template" , EOL;
$objReader = PHPExcel_IOFactory::createReader('Excel5');
$objPHPExcel = $objReader->load("templates/template_dapok.xls");


include("../../koneksi_lokal.php");
$bulan_aktif = $_GET['bulan_aktif'];	
$tahun = substr($bulan_aktif,-4);
$bulan = (substr($bulan_aktif,0,2)+100)-101;

$namaBulan = array("Januari","Februari","Maret","April","Mei","Juni","Juli","Agustus","September","Oktober","November","Desember");
$objPHPExcel->getActiveSheet()->setCellValue('A2','KEADAAN 1 '.$namaBulan[$bulan].' '.$tahun); 
 
//echo date('H:i:s') , " Add new data to the template" , EOL;

//------------- berdasarkan eselon dan jenis kelamin ---------//

$jenis_jabatan_data = array("STRUKTURAL","JFT","JFU");
$kode_eselon_data = array("21","22","31","32","41","42");
$kode_eselon_text_data = array("II.a","II.b","III.a","III.b","IV.a","IV.b");
											
for($i=0;$i<count($jenis_jabatan_data);$i++){							
	$jenis_jabatan = $jenis_jabatan_data[$i];
	$query2 = "	select count(*) as jumlah 
				from r_pns_jabatan_akhir_12_".$bulan_aktif." t1				
				where t1.nip !=''										
			";
	if($jenis_jabatan == "STRUKTURAL"){		
		$row = 6;
		for($b=0;$b<count($kode_eselon_text_data);$b++){
		$row2 = $row+$b;
		$kode_eselon_text = $kode_eselon_text_data[$b];
		$kode_eselon = $kode_eselon_data[$b];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'STRUKTURAL' and t1.kode_eselon = '$kode_eselon' and t1.jenis_kelamin=1 ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah_pria = $hasil2['jumlah'];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'STRUKTURAL' and t1.kode_eselon = '$kode_eselon' and t1.jenis_kelamin=2 ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah_wanita = $hasil2['jumlah'];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'STRUKTURAL' and t1.kode_eselon = '$kode_eselon'");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		
		$objPHPExcel->getActiveSheet()->setCellValue('C'.$row2,$jumlah_pria);
		$objPHPExcel->getActiveSheet()->setCellValue('D'.$row2,$jumlah_wanita);
		$objPHPExcel->getActiveSheet()->setCellValue('E'.$row2,$jumlah);	
		}
	}
	if($jenis_jabatan == "JFT"){		
		$row = 12;								
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFT' and t1.jenis_kelamin=1 ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah_pria = $hasil2['jumlah'];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFT' and t1.jenis_kelamin=2 ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah_wanita = $hasil2['jumlah'];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFT'");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		
		$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
		$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
		$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);			
	}
	if($jenis_jabatan == "JFU"){		
		$row = 13;													
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFU' and t1.jenis_kelamin=1 ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah_pria = $hasil2['jumlah'];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFU' and t1.jenis_kelamin=2 ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah_wanita = $hasil2['jumlah'];
		
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFU'");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		
		$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
		$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
		$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);			
	}

	$row = 14;													
	$stid2 = pg_query($conn,$query2." and (t1.text_jabatan = 'STRUKTURAL' or t1.text_jabatan = 'JFT' or t1.text_jabatan = 'JFU') and t1.jenis_kelamin=1 ");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	
	$stid2 = pg_query($conn,$query2." and (t1.text_jabatan = 'STRUKTURAL' or t1.text_jabatan = 'JFT' or t1.text_jabatan = 'JFU') and t1.jenis_kelamin=2 ");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	
	$stid2 = pg_query($conn,$query2." and (t1.text_jabatan = 'STRUKTURAL' or t1.text_jabatan = 'JFT' or t1.text_jabatan = 'JFU')");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);		

}
//----------------- BERDASARKAN TINGKAT PENDIDIKAN ---------------//
$query1 = "	select 
					t1.kode_tingkat_pendidikan ,
					t1.tingkat_pendidikan ,
					t1.id 
			from 
					a2_tingkat_pendidikan t1	
			order by
					NULLIF(t1.id, '')::int asc
			";						
$stid1 = pg_query($conn,$query1);
$row = 6;									
while($hasil1=pg_fetch_assoc($stid1)){
	$kode_tingkat_pendidikan = $hasil1['kode_tingkat_pendidikan'];
	$query2 = "	select 
						count(*) as jumlah
				from(
					select 
							nip
					from 		
							r_pns_lengkap_11_".$bulan_aktif." t1
					where 
							t1.nip !=''		
				";
	$stid2 = pg_query($conn,$query2." and kode_tingkat_pendidikan= '$kode_tingkat_pendidikan' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_tingkat_pendidikan= '$kode_tingkat_pendidikan' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_tingkat_pendidikan= '$kode_tingkat_pendidikan' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$jumlah);		
	$row++;
}
	$row = 15;
	$stid2 = pg_query($conn,$query2." and kode_tingkat_pendidikan != ''  and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_tingkat_pendidikan != ''  and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_tingkat_pendidikan != '' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$jumlah);	
			
//------------------------ KELOMPOK USIA dan JENIS KELAMIN ------------------//
$query2 = "	select 
				count(*) as jumlah
			from(
				select 
						nip,
						usia_tahun ,
						usia_bulan 
				from 		
						r_pns_jabatan_akhir_12_".$bulan_aktif." t1
				where 
						t1.nip !=''		
			";
$usia_awal_data = array(20,26,31,36,41,46,51,56);
$usia_akhir_data = array(25,30,35,40,45,50,55,100);
$row = 20;
for($i=0;$i<8;$i++){						
	$usia_awal = $usia_awal_data[$i];
	$usia_akhir = $usia_akhir_data[$i];						

	$stid2 = pg_query($conn,$query2." and usia_tahun>= '$usia_awal' and usia_tahun <= '$usia_akhir' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and usia_tahun>= '$usia_awal' and usia_tahun <= '$usia_akhir' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and usia_tahun>= '$usia_awal' and usia_tahun <= '$usia_akhir') xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$jumlah);	
	$row++;
}
	$usia_awal = 20;
	$usia_akhir = 100;
	$row = 28;
	$stid2 = pg_query($conn,$query2." and usia_tahun>= '$usia_awal' and usia_tahun <= '$usia_akhir' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and usia_tahun>= '$usia_awal' and usia_tahun <= '$usia_akhir' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and usia_tahun>= '$usia_awal' and usia_tahun <= '$usia_akhir') xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$jumlah);							

//------------------- Masa Kerja dan Jenis Kelamin ----------------//
$query2 = "	select 
						count(*) as jumlah
				from(
					select 
							nip,
							tmt_cpns ,
							tahun ,
							bulan
					from 		
							r_pns_lengkap_11_".$bulan_aktif." t1
					where 
							t1.nip !=''		
				";
$row = 33;
for($i=0;$i<9;$i++){						
	$tahun_cpns_awal = $i*5;
	$tahun_cpns_akhir = $tahun_cpns_awal + 5;		

	$stid2 = pg_query($conn,$query2." and tahun> '$tahun_cpns_awal' and tahun <= '$tahun_cpns_akhir' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and tahun> '$tahun_cpns_awal' and tahun <= '$tahun_cpns_akhir' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and tahun> '$tahun_cpns_awal' and tahun <= '$tahun_cpns_akhir') xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$jumlah);
	$row++;
}
	$row = 42;
	$tahun_cpns_awal = 0;
	$tahun_cpns_akhir = 45;
	$stid2 = pg_query($conn,$query2." and tahun> '$tahun_cpns_awal' and tahun <= '$tahun_cpns_akhir' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and tahun> '$tahun_cpns_awal' and tahun <= '$tahun_cpns_akhir' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and tahun> '$tahun_cpns_awal' and tahun <= '$tahun_cpns_akhir') xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('L'.$row,$jumlah);						
	

//------------------- AGAMA dan JENIS KELAMIN ----------------------//
					
$agama_array = array(1,5,2,4,3);
$nama_agama_array = array("ISLAM","KATOLIK","PROTESTAN","BUDHA","HINDU");
$row = 44;

for($i=0;$i<count($agama_array);$i++){
	$agama = $agama_array[$i];
	$query2 = "	select 
						count(*) as jumlah
				from(
					select 
							nip
					from 		
							r_pns_lengkap_11_".$bulan_aktif."
					where 
							nip !=''		
				";
	$stid2 = pg_query($conn,$query2." and agama= '$agama' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and agama= '$agama' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and agama= '$agama' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	$row++;
}
	$row = 49;
	$data_agama = "'".implode("','",$agama_array)."'";
	$stid2 = pg_query($conn,$query2." and agama in (".$data_agama .") and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and agama in (".$data_agama .") and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and agama in (".$data_agama .") ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	

//------------------------- GOLONGAN I DAN JENIS KELAMIN -------------------//
$kode_golongan_pangkat_array = array(11,12,13,14);
$row = 19;

for($i=0;$i<count($kode_golongan_pangkat_array);$i++){
	$kode_golongan_pangkat = $kode_golongan_pangkat_array[$i];
	$query2 = "	select 
					count(*) as jumlah
				from(
					select 
							nip
					from 		
							r_pns_lengkap_11_".$bulan_aktif." t1
					where 
							t1.nip !=''		
				";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	$row++;
}
	$row = 23;
	$data_kode_golongan_pangkat = "'".implode("','",$kode_golongan_pangkat_array)."'";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	

//------------------------- GOLONGAN II DAN JENIS KELAMIN -------------------//
$kode_golongan_pangkat_array = array(21,22,23,24);
$row = 24;

for($i=0;$i<count($kode_golongan_pangkat_array);$i++){
	$kode_golongan_pangkat = $kode_golongan_pangkat_array[$i];
	$query2 = "	select 
					count(*) as jumlah
				from(
					select 
							nip
					from 		
							r_pns_lengkap_11_".$bulan_aktif." t1
					where 
							t1.nip !=''		
				";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	$row++;
}
	$row = 28;
	$data_kode_golongan_pangkat = "'".implode("','",$kode_golongan_pangkat_array)."'";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);		

//------------------------- GOLONGAN III DAN JENIS KELAMIN -------------------//
$kode_golongan_pangkat_array = array(31,32,33,34);
$row = 29;

for($i=0;$i<count($kode_golongan_pangkat_array);$i++){
	$kode_golongan_pangkat = $kode_golongan_pangkat_array[$i];
	$query2 = "	select 
					count(*) as jumlah
				from(
					select 
							nip
					from 		
							r_pns_lengkap_11_".$bulan_aktif." t1
					where 
							t1.nip !=''		
				";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	$row++;
}
	$row = 33;
	$data_kode_golongan_pangkat = "'".implode("','",$kode_golongan_pangkat_array)."'";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	

//------------------------- GOLONGAN IV DAN JENIS KELAMIN -------------------//
$kode_golongan_pangkat_array = array(41,42,43,44);
$row = 34;

for($i=0;$i<count($kode_golongan_pangkat_array);$i++){
	$kode_golongan_pangkat = $kode_golongan_pangkat_array[$i];
	$query2 = "	select 
					count(*) as jumlah
				from(
					select 
							nip
					from 		
							r_pns_lengkap_11_".$bulan_aktif." t1
					where 
							t1.nip !=''		
				";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat= '$kode_golongan_pangkat' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	$row++;
}
	$row = 38;
	$data_kode_golongan_pangkat = "'".implode("','",$kode_golongan_pangkat_array)."'";
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat in (".$data_kode_golongan_pangkat.") ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	
	$row = 39;	
	$kode_golongan_pangkat_awal = 11;
	$kode_golongan_pangkat_akhir = 45;
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat>= '$kode_golongan_pangkat_awal'  and kode_golongan_pangkat<= '$kode_golongan_pangkat_akhir' and jenis_kelamin = 1) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat>= '$kode_golongan_pangkat_awal'  and kode_golongan_pangkat<= '$kode_golongan_pangkat_akhir' and jenis_kelamin = 2) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and kode_golongan_pangkat>= '$kode_golongan_pangkat_awal'  and kode_golongan_pangkat<= '$kode_golongan_pangkat_akhir' ) xxx");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	

//-------------------------------- berdasarkan eselon dan pendidikan -------------------------//	
$jenis_jabatan_data = array("STRUKTURAL","JFT","JFU");
$kode_eselon_data = array("21","22","31","32","41","42");
$kode_eselon_text_data = array("II.a","II.b","III.a","III.b","IV.a","IV.b");
$kode_tingkat_pendidikan_data = array("01","02","03","06","07","08","09","04","05");
											
for($i=0;$i<count($jenis_jabatan_data);$i++){
	$query2 = "	select count(*) as jumlah 
				from r_pns_jabatan_akhir_12_".$bulan_aktif." t1
				left join  r_pns_lengkap_11_".$bulan_aktif." t2
				on(t1.nip = t2.nip)
				where t1.nip !=''										
			";
	$jenis_jabatan = $jenis_jabatan_data[$i];
	$row = 54;
	if($jenis_jabatan == "STRUKTURAL"){	
	for($b=0;$b<count($kode_eselon_text_data);$b++){
	$kode_eselon_text = $kode_eselon_text_data[$b];
	$kode_eselon = $kode_eselon_data[$b];	
	//--------- table data---//		
	$kolom_array = array('C','D','E','F','G','H','I','J','K');
	for($c=0;$c<count($kode_tingkat_pendidikan_data);$c++){
		$kolom2 = $kolom_array[$c];
		$kode_tingkat_pendidikan = $kode_tingkat_pendidikan_data[$c];							
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'STRUKTURAL' and t1.kode_eselon = '$kode_eselon' and t2.kode_tingkat_pendidikan = '$kode_tingkat_pendidikan' ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	}
	//----------------- Jumlah table data ---------//
	$kolom2 = 'L';
	$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'STRUKTURAL' and t1.kode_eselon = '$kode_eselon' ");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	$row++;
	}	
	}
	
	if($jenis_jabatan == "JFT"){
	//--------- table data---//	
	$row = 60;
	$kolom_array = array('C','D','E','F','G','H','I','J','K');
	for($c=0;$c<count($kode_tingkat_pendidikan_data);$c++){
		$kolom2 = $kolom_array[$c];
		$kode_tingkat_pendidikan = $kode_tingkat_pendidikan_data[$c];							
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFT' and t2.kode_tingkat_pendidikan = '$kode_tingkat_pendidikan' ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	}
	//----------------- Jumlah table data ---------//
	$kolom2 = 'L';
	$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFT' ");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	$row++;
	}
	
	if($jenis_jabatan == "JFU"){		
	//--------- table data---//	
	$row = 61;
	$kolom_array = array('C','D','E','F','G','H','I','J','K');
	for($c=0;$c<count($kode_tingkat_pendidikan_data);$c++){
		$kolom2 = $kolom_array[$c];
		$kode_tingkat_pendidikan = $kode_tingkat_pendidikan_data[$c];							
		$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFU' and t2.kode_tingkat_pendidikan = '$kode_tingkat_pendidikan' ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	}
	//----------------- Jumlah table data ---------//
	$kolom2 = 'L';
	$stid2 = pg_query($conn,$query2." and t1.text_jabatan = 'JFU' ");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	$row++;
	}
}
	
	$row = 62;
	$kolom_array = array('C','D','E','F','G','H','I','J','K');
	$data_kode_tingkat_pendidikan = "'".implode("','",$kode_tingkat_pendidikan_data)."'";
	for($c=0;$c<count($kode_tingkat_pendidikan_data);$c++){
		$kolom2 = $kolom_array[$c];
		$kode_tingkat_pendidikan = $kode_tingkat_pendidikan_data[$c];							
		$stid2 = pg_query($conn,$query2." and t2.kode_tingkat_pendidikan = '$kode_tingkat_pendidikan' ");								
		$hasil2=pg_fetch_assoc($stid2);
		$jumlah = $hasil2['jumlah'];
		$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	
	}
	//----------------- Jumlah table data ---------//
	$kolom2 = 'L';
	$stid2 = pg_query($conn,$query2." and t2.kode_tingkat_pendidikan  in (".$data_kode_tingkat_pendidikan.") ");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];
	$objPHPExcel->getActiveSheet()->setCellValue($kolom2.$row,$jumlah);	

//---------- berdasarkan unitkerja PNS, CPNS dan jenis kelamin -------------------------//
$query = "	select 
					kode_instansi_induk ,
					nama_instansi_induk 
			from a2_instansi_induk
			where kode_instansi_induk
			in 
			(
				select         
					t1.kode_instansi_induk
				from
						A2_UNIT_KERJA t1
				where 
						t1.status_unit_kerja = 1
				group by
						t1.kode_instansi_induk
			)
			order by CAST(coalesce(kode_instansi_induk, '0') AS integer) asc	
			";
$stid1 = pg_query($conn,$query);	
$a=1;
$row = 68;
while($hasil1=pg_fetch_assoc($stid1)){
	$kode_instansi_induk = $hasil1['kode_instansi_induk'];
	$nama_instansi_induk = $hasil1['nama_instansi_induk'];
	$nama_instansi_induk = trim(ucwords(strtolower($hasil1['nama_instansi_induk'])));
	$objPHPExcel->getActiveSheet()->setCellValue('A'.$row,$a);
	$objPHPExcel->getActiveSheet()->setCellValue('B'.$row,$nama_instansi_induk);
	
	$query2 = "	select count(*) as jumlah 
				from r_pns_lengkap_11_".$bulan_aktif."
				where nip !=''
				and kode_instansi_induk  = '$kode_instansi_induk'
			";
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 2 and jenis_kelamin = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 2 and jenis_kelamin = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 1 and jenis_kelamin = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 1 and jenis_kelamin = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('F'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('G'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('H'.$row,$jumlah);	
	
	$stid2 = pg_query($conn,$query2." and (status_kepegawaian = 1 or status_kepegawaian = 2) and jenis_kelamin = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and (status_kepegawaian = 1 or status_kepegawaian = 2) and jenis_kelamin = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and (status_kepegawaian = 1 or status_kepegawaian = 2)");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('I'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah);	
	
	$row++;
	$a++;
}
	$row = 106;
	$query2 = "	select count(*) as jumlah 
				from r_pns_lengkap_11_".$bulan_aktif."
				where nip !=''				
			";
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 2 and jenis_kelamin = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 2 and jenis_kelamin = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('C'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('D'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('E'.$row,$jumlah);	
	
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 1 and jenis_kelamin = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 1 and jenis_kelamin = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and status_kepegawaian = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('F'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('G'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('H'.$row,$jumlah);	
	
	$stid2 = pg_query($conn,$query2." and (status_kepegawaian = 1 or status_kepegawaian = 2) and jenis_kelamin = 1");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_pria = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and (status_kepegawaian = 1 or status_kepegawaian = 2) and jenis_kelamin = 2");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah_wanita = $hasil2['jumlah'];
	$stid2 = pg_query($conn,$query2." and (status_kepegawaian = 1 or status_kepegawaian = 2)");								
	$hasil2=pg_fetch_assoc($stid2);
	$jumlah = $hasil2['jumlah'];	
	
	$objPHPExcel->getActiveSheet()->setCellValue('I'.$row,$jumlah_pria);
	$objPHPExcel->getActiveSheet()->setCellValue('J'.$row,$jumlah_wanita);
	$objPHPExcel->getActiveSheet()->setCellValue('K'.$row,$jumlah);	
	
//echo date('H:i:s') , " Write to Excel5 format" , EOL;
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save(str_replace('.php', '.xls', __FILE__));
//echo date('H:i:s') , " File written to " , str_replace('.php', '.xls', pathinfo(__FILE__, PATHINFO_BASENAME)) , EOL;


// Echo memory peak usage
//echo date('H:i:s') , " Peak memory usage: " , (memory_get_peak_usage(true) / 1024 / 1024) , " MB" , EOL;

// Echo done
//echo date('H:i:s') , " Done writing file" , EOL;
//echo 'File has been created in ' , getcwd() , EOL;
//echo '<a href="https://36.67.113.243:8895/PHPExcel/Examples/download_rekap.xls">Download File</a>';
header("location: https://36.67.113.243:8895/PHPExcel/Examples/download_rekap.xls");