<?php

use setasign\Fpdi\Fpdi;

require_once('12.fpdf/mc_table.php');
require_once('11.fpdi/autoload.php');
include('14.phpqrcode/phpqrcode.php');
include 'function_simpeg_asn.php';
include 'enkripsi.php';
include 'koneksi_lokal_open.php';

define('FPDF_FONTPATH','12.fpdf/font/');
// initiate FPDI
$pdf = new Fpdi('P', 'mm', array(210,297));
//$pdf->AddFont('test','B','MATURASC.php');

class PDF extends FPDF
{
protected $col = 0;

function SetCol($col)
{
    // Set position on top of a column
    $this->col = $col;
    $this->SetLeftMargin(10+$col*40);
    $this->SetY(25);
}

function AcceptPageBreak()
{
    // Go to the next column
    $this->SetCol($this->col+1);
    return false;
}

function DumpFont($FontName)
{
    $this->AddPage();
    // Title
    $this->SetFont('Arial','',16);
    $this->Cell(0,6,$FontName,0,1,'C');
    // Print all characters in columns
    $this->SetCol(0);
    for($i=32;$i<=255;$i++)
    {
        $this->SetFont('Arial','',14);
        $this->Cell(12,5.5,"$i : ");
        $this->SetFont($FontName);
        $this->Cell(0,5.5,chr($i),0,1);
    }
    $this->SetCol(0);
}
}



//id
$id = $_GET['id'];
$id_enkrip = $_GET['id'];
$id	= base64_decrypt($id,$key);


$query = " select 
				t1.id_l2_kirim_pricelist ,
				t1.nama ,
				t1.inisial ,
				t1.cp ,
				t1.no_hp ,
				t1.alamat ,
				t1.jenis_pengujian ,
				t1.file_pdf ,
				t1.status_persetujuan ,
				t1.tanggal_input,
				ROW_NUMBER() OVER (ORDER BY id_l2_kirim_pricelist) AS no_urut
			from l2_kirim_pricelist t1		
			where 	t1.id_l2_kirim_pricelist >0
			and		t1.id_l2_kirim_pricelist = '$id'
		";
$stid1 = pg_query($conn, $query);	    		
$hasil1 = pg_fetch_array($stid1);



$tanggal_penawaran = format_tanggal_text($hasil1['tanggal_input']);
$tanggal_penawaran2 	= format_tanggal_bulan_text($tanggal_penawaran);
$nama 	= $hasil1['nama'];
$inisial= $hasil1['inisial'];			
$cp= $hasil1['cp'];			
$no_hp 	= $hasil1['no_hp'];			
$alamat 	= $hasil1['alamat'];			
$jenis_pengujian 	= $hasil1['jenis_pengujian'];			
$file_pdf 	= $hasil1['file_pdf'];			
$status_persetujuan 	= $hasil1['status_persetujuan'];			


$lokasi_file 	= 'qr_code/3.kirim_pricelist/'.$id.'.png';
if(file_exists($lokasi_file)){unlink($lokasi_file);}
// creates qrcode
QRcode::png($file_pdf, $lokasi_file); 


$pdf->AddPage();
$pdf->setSourceFile('kop_surat_vander.pdf');
$tplIdx = $pdf->importPage(1);
$pdf->useTemplate($tplIdx, 0, 0, 210);
$pdf->SetTitle('price_list');
$pdf->SetFont('Arial','',11);

//--- header ---//
$pdf->SetXY(15, 35);
$pdf->Cell(30,5,'Nomor',0,0,'L');
$pdf->Cell(150,5,' : - ',0,1,'L');
$pdf->SetX(15);
$pdf->Cell(30,5,'Perihal',0,0,'L');
$pdf->SetFont('Arial','B',11);
$pdf->Cell(150,5,' : Penawaran Harga Uji Laboratorium',0,1,'L');
$pdf->SetFont('Arial','',11);

$pdf->SetXY(15, 48);
$pdf->Cell(185,5,'Kepada Yth',0,1,'L');
$pdf->SetFont('Arial','B',11);
$pdf->SetX(15);
$pdf->Cell(185,5,'Pimpinan',0,1,'L');
$pdf->SetX(15);
$pdf->Cell(185,5,$hasil1['nama'],0,1,'L');
$pdf->SetFont('Arial','',11);
$pdf->SetXY(15, 63);
$pdf->SetX(15);
$pdf->Cell(185,5,'Di-',0,1,'L');
$pdf->SetX(25);
$pdf->Cell(185,5,'Tempat',0,1,'L');

$pdf->SetXY(15, 75);
$pdf->SetX(15);
$pdf->Cell(185,5,'Dengan hormat,',0,1,'L');
$pdf->SetX(15);
//$pdf->Cell(185,5,'Berikut Kami Lampirkan Price List Analisa Sample Geotek sebagai berikut:',0,1,'L');
$pdf->MultiCell(185, 5, 'Sehubungan dengan rencana '.$hasil1['nama'].' yang akan melakukan Analisis Batuan dan/atau Tanah, untuk itu kami atas nama Management PT. VANDER GEO LABORATORY memberi penawaran harga uji sampel sebagai berikut', 0, 'J', FALSE);

   
$pdf->SetXY(25, 97);
$pdf->SetFont('Arial','B',8);
$pdf->SetX(25);
$pdf->Cell(10,5,'NO',1,0,'C');
$pdf->Cell(65,5,'TEST',1,0,'C');
$pdf->Cell(25,5,'OUTPUT',1,0,'C');
$pdf->Cell(30,5,'STANDARD',1,0,'C');
$pdf->Cell(10,5,'QTY',1,0,'C');
$pdf->Cell(20,5,'RATES',1,1,'C');



$query ="select 
			t1.id_l2_kategori_penawaran ,
			t1.nama ,
			t1.output ,
			t1.standard ,
			t1.qty ,
			t1.rates ,
			t1.jenis_pengujian ,
			t1.urutan ,
			t1.status,
			ROW_NUMBER() OVER (ORDER BY id_l2_kategori_penawaran ASC) AS no_urut 
		from l2_kategori_penawaran t1						
		where 	t1.id_l2_kategori_penawaran >0
		";
$a=0;
$alphabet = range('A', 'Z');
$stid1 = pg_query($conn, $query);
while($hasil1 = pg_fetch_array($stid1)){
	$id_l2_kategori_penawaran = $hasil1['id_l2_kategori_penawaran'];
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(25);
	//$pdf->Cell(7,5,$alphabet[$a],1,0,'L');
	$pdf->Cell(5,5,$alphabet[$a],'LTR',0,'C',0); 
	$pdf->Cell(70,5,$hasil1['nama'],1,0,'C');
	$pdf->Cell(25,5,'',1,0,'C');
	$pdf->Cell(30,5,'',1,0,'C');
	$pdf->Cell(10,5,'',1,0,'C');
	$pdf->Cell(20,5,'',1,1,'C');
	
	//---- sub kategori penawaran ---//
	$query2 ="select 
					t1.id_l2_sub_kategori_penawaran ,
					t1.id_l2_kategori_penawaran ,
					t1.nama ,
					t1.output ,
					t1.standard ,
					t1.qty ,
					t1.rates ,
					t1.file_symbol ,
					t1.urutan ,
					t1.status,
					ROW_NUMBER() OVER (ORDER BY id_l2_sub_kategori_penawaran, urutan ASC) AS no_urut 
				from l2_sub_kategori_penawaran t1						
				where 	t1.id_l2_sub_kategori_penawaran >0
				and id_l2_kategori_penawaran = '$id_l2_kategori_penawaran'
	";
	$stid2 = pg_query($conn, $query2);
	$b=1;
	$new_page = 0;
	while($hasil2 = pg_fetch_array($stid2)){
		$id_l2_sub_kategori_penawaran = $hasil2['id_l2_sub_kategori_penawaran'];
		$posisi_y = $pdf->GetY();
		$jumlah_huruf = strlen($hasil2['output']);
		$banyak_baris = ceil($jumlah_huruf/17);
		$pdf->SetFont('Arial','',8);
		$pdf->SetX(25);
		$pdf->Cell(5,5*$banyak_baris,'','LR',0,'C',0); 
		//$pdf->Cell(8,5,$b,1,0,'L');
		$pdf->Cell(5,5*$banyak_baris,$b,'LTR',0,'C',0); 
		
		$pdf->Cell(65,5*$banyak_baris,$hasil2['nama'],1,0,'L');		
		$pdf->SetFont('symbol','',7);
					
		if($hasil2['output']){	
			$image1 = $hasil2['file_symbol'];
			if($banyak_baris>1){
				$y = $pdf->GetY();
				$x = $pdf->GetX();
				$width = 25;
				if(file_exists($image1)){
					$pdf->MultiCell($width, 5*$banyak_baris, $pdf->Image($image1, $pdf->GetX(), $pdf->GetY(), 25), 1, 'C', FALSE);
				}else{
					$pdf->MultiCell($width, 5*$banyak_baris, '', 1, 'C', FALSE);
				}
				$pdf->SetXY($x + $width, $y);
			}else{
				//$pdf->Cell(25,5*$banyak_baris,$test,1,0,'C');				
				//$s = str_replace("\r",'',$txt ?? '');	
				if(file_exists($image1 ?? '')){
					$pdf->Cell( 25, 5*$banyak_baris, $pdf->Image($image1, $pdf->GetX(), $pdf->GetY(), 25), 1, 0, 'C',false  );
				}else{
					$pdf->Cell(25,5*$banyak_baris,'',1,0,'C');
				}
			}
		}else{
			$pdf->Cell(25,5*$banyak_baris,'',1,0,'C');	
		}
		$pdf->SetFont('Arial','',8);
		if($hasil2['standard']){
			$pdf->Cell(30,5*$banyak_baris,$hasil2['standard'],1,0,'C');
		}else{
			$pdf->Cell(30,5*$banyak_baris,'',1,0,'C');	
		}
		if($hasil2['qty']){
			$pdf->Cell(10,5*$banyak_baris,$hasil2['qty'],1,0,'C');
		}else{
			$pdf->Cell(10,5*$banyak_baris,'',1,0,'C');	
		}
		if($hasil2['rates']){
			$pdf->Cell(20,5*$banyak_baris,number_format($hasil2['rates']),1,1,'R');
		}else{
			$pdf->Cell(20,5*$banyak_baris,'',1,1,'R');	
		}
		
		if($posisi_y>=245 && $new_page == 0){
			$new_page++;
			$pdf->AddPage();
			$pdf->setSourceFile('kop_surat_vander.pdf');
			$tplIdx = $pdf->importPage(1);
			$pdf->useTemplate($tplIdx, 0, 0, 210);
			$pdf->SetY(45);
		}
		//--- sub sub kategori ---//
		$query3 ="select 
								t1.id_l2_sub_sub_kategori_penawaran ,
								t1.id_l2_sub_kategori_penawaran ,
								t1.id_l2_kategori_penawaran ,
								t1.nama ,
								t1.output ,
								t1.standard ,
								t1.qty ,
								t1.rates ,
								t1.file_symbol ,
								t1.urutan ,
								t1.status,
								ROW_NUMBER() OVER (ORDER BY id_l2_sub_sub_kategori_penawaran, urutan ASC) AS no_urut 
							from l2_sub_sub_kategori_penawaran t1						
							where 	t1.id_l2_sub_sub_kategori_penawaran >0
							and id_l2_sub_kategori_penawaran = '$id_l2_sub_kategori_penawaran'
		";
		$stid3 = pg_query($conn, $query3);
		$jumlah_row3 = 0;		
		while($hasil3 = pg_fetch_array($stid3)){
			$id4  = base64_encrypt($hasil3['id_l2_sub_sub_kategori_penawaran'], $key);
			$id_l2_sub_sub_kategori_penawaran = $hasil3['id_l2_sub_sub_kategori_penawaran'];
			$posisi_y = $pdf->GetY();
			$jumlah_huruf = strlen($hasil3['output']);
			$banyak_baris = ceil($jumlah_huruf/17);
			$pdf->SetFont('Arial','',8);
			$pdf->SetX(25);
			$pdf->Cell(5,5*$banyak_baris,'','LR',0,'C',0); 
			$pdf->Cell(5,5*$banyak_baris,'','LR',0,'C',0); 
			$pdf->Cell(65,5*$banyak_baris,'- '.$hasil3['nama'],1,0,'L');
			$pdf->SetFont('Arial','',9);			
			if($hasil3['output']){	
				$image1 = $hasil3['file_symbol'];
				if($banyak_baris>1){
					$y = $pdf->GetY();
					$x = $pdf->GetX();
					$width = 25;
					if(file_exists($image1)){
						$pdf->MultiCell($width, 5*$banyak_baris, $pdf->Image($image1, $pdf->GetX(), $pdf->GetY(), 25), 1, 'C', FALSE);
					}else{
						$pdf->MultiCell($width, 5*$banyak_baris, '', 1, 'C', FALSE);
					}
					$pdf->SetXY($x + $width, $y);
				}else{
					//$pdf->Cell(25,5*$banyak_baris,$test,1,0,'C');				
					if(file_exists($image1 ?? '')){
						$pdf->Cell( 25, 5*$banyak_baris, $pdf->Image($image1, $pdf->GetX(), $pdf->GetY(), 25), 1, 0, 'C',false  );
					}else{
						$pdf->Cell(25,5*$banyak_baris,'',1,0,'C');
					}
				}
			}else{
				$pdf->Cell(25,5*$banyak_baris,'',1,0,'C');	
			}
			$pdf->SetFont('Arial','',8);
			if($hasil3['standard']){
				$pdf->Cell(30,5*$banyak_baris,$hasil3['standard'],1,0,'C');
			}else{
				$pdf->Cell(30,5*$banyak_baris,'',1,0,'C');	
			}
			if($hasil3['qty']){
				$pdf->Cell(10,5*$banyak_baris,$hasil3['qty'],1,0,'C');
			}else{
				$pdf->Cell(10,5*$banyak_baris,'',1,0,'C');	
			}
			if($hasil3['rates']){
				$pdf->Cell(20,5*$banyak_baris,number_format($hasil3['rates']),1,1,'R');
			}else{
				$pdf->Cell(20,5*$banyak_baris,'',1,1,'R');	
			}						
			$jumlah_row3++;	
			if($posisi_y>=245 && $new_page == 0){
				$new_page++;
				$pdf->AddPage();
				$pdf->setSourceFile('kop_surat_vander.pdf');
				$tplIdx = $pdf->importPage(1);
				$pdf->useTemplate($tplIdx, 0, 0, 210);
				$pdf->SetY(45);
			}
		}		
		$b++;
	}
	$a++;
}
$y = $pdf->GetY();
$x = $pdf->GetX();
//---- halaman ke 2 ---//
/*


*/
$pdf->SetTitle('surat_penawaran');
$pdf->SetFont('Arial','',11);
//--- header ---//
$pdf->Cell(185,2,'',0,1,'L');
$pdf->SetX(15);
$pdf->MultiCell(185, 5, 'Demikian Penawaran Harga ini kami sampaikan, yang nantinya dapat sebagai bahan pertimbangan. Atas perhatiannya kami ucapkan terimakasih.', 0, 'J', FALSE);
//$pdf->Cell(185,5,'Demikian Price List ini kami sampaikan, yang nantinya dapat sebagai bahan pertimbangan. Atas',0,1,'L');
$pdf->SetX(15);
//$pdf->Cell(185,5,'perhatiannya kami ucapkan terimakasih.',0,1,'L');

$pdf->Cell(185,5,'',0,1,'L');
$pdf->Cell(185,5,'',0,1,'L');
$pdf->SetX(145);
$pdf->Cell(55,5,'Samarinda, '.$tanggal_penawaran2,0,1,'L');
$posisi_x = $pdf->GetX();
$posisi_y = $pdf->GetY();

if($status_persetujuan == 5){
	$pdf->Image('qr_code/3.kirim_pricelist/'.$id.'.png',160,$posisi_y+5,30,30);
	$pdf->SetXY(147,$posisi_y+35);
	$pdf->SetFont('Arial','B',11);
	$pdf->Cell(55,5,'Donny A. Kismat, S.T',0,1,'C');
	$pdf->SetX(147);
	$pdf->SetFont('Arial','',11);
	$pdf->Cell(55,5,'Direktur Utama',0,1,'C');
}else{
	$pdf->SetXY(15,$posisi_y+10);
	$pdf->SetFont('Arial','B',32);
	$pdf->Cell(185,5,'DRAFT SURAT PENAWARAN',0,1,'C');
}

/*
$pdf->Image('qr_code/3.kirim_pricelist/'.$id.'.png',160,$posisi_y+5,30,30);
$pdf->SetXY(147,$posisi_y+35);
$pdf->SetFont('Arial','B',11);
$pdf->Cell(55,5,'Donny A. Kismat, S.T',0,1,'C');
$pdf->SetX(147);
$pdf->SetFont('Arial','',11);
$pdf->Cell(55,5,'Direktur Utama',0,1,'C');
*/

$pdf->Output();
$id_enkrip = str_replace("/","",$id_enkrip);
$id_enkrip = str_replace("@","",$id_enkrip);
$id_enkrip = str_replace("=","",$id_enkrip);
$filename="upload/file_pdf_kirim_pricelist/".$id_enkrip.".pdf";
$pdf->Output($filename,'F');
