<?php

use setasign\Fpdi\Fpdi;

require_once('12.fpdf/mc_table.php');
require_once('11.fpdi/autoload.php');
include('14.phpqrcode/phpqrcode.php');
include 'function_simpeg_asn.php';
include 'enkripsi.php';
include 'koneksi_lokal_open.php';

define('FPDF_FONTPATH','12.fpdf/font/');
// initiate FPDI
$pdf = new Fpdi('P', 'mm', array(210,297));
//$pdf->AddFont('test','B','MATURASC.php');


//id
$id = $_GET['id'];
$id_enkrip = $_GET['id'];
$id	= base64_decrypt($id,$key);


$query = " select 
				t1.id_l2_daftar_penawaran_lingkungan ,
				t1.id_l2_daftar_customer ,
				t1.nomor_surat ,
				t1.tanggal_penawaran ,
				t1.nama ,
				t1.inisial,
				t1.cp,
				t1.no_hp,
				t1.alamat,
				t1.jenis_pengujian,
				t1.sum_banyak,
				t1.sum_total,
				t1.diskon,
				t1.harga_final,
				t1.status_persetujuan,
				t1.revisi,
				t1.file_pdf,
				t1.tanggal_update,
				ROW_NUMBER() OVER (ORDER BY id_l2_daftar_penawaran_lingkungan ASC) AS no_urut 
			from l2_daftar_penawaran_lingkungan t1						
			where 	t1.id_l2_daftar_penawaran_lingkungan >0
			and		t1.id_l2_daftar_penawaran_lingkungan = '$id'
		";
$stid1 = pg_query($conn, $query);	    		
$hasil1 = pg_fetch_array($stid1);

$id_l2_daftar_penawaran_lingkungan	= $hasil1['id_l2_daftar_penawaran_lingkungan'];
$id_l2_daftar_customer	= $hasil1['id_l2_daftar_customer'];
if($hasil1['revisi']){				
$nomor_surat 	= $hasil1['nomor_surat'].'/REV-'.$hasil1['revisi'];
}else{
$nomor_surat 	= $hasil1['nomor_surat'];
}

$tanggal_penawaran = format_tanggal_text($hasil1['tanggal_penawaran']);
$tanggal_penawaran2 	= format_tanggal_bulan_text($tanggal_penawaran);
$tanggal_approval = format_tanggal_text($hasil1['tanggal_update']);
$nama 	= $hasil1['nama'];
$inisial= $hasil1['inisial'];			
$cp= $hasil1['cp'];			
$no_hp 	= $hasil1['no_hp'];			
$alamat 	= $hasil1['alamat'];			
$jenis_pengujian 	= $hasil1['jenis_pengujian'];			
$sum_banyak 	= $hasil1['sum_banyak'];			
$sum_total 	= $hasil1['sum_total'];			
$file_pdf 		= $hasil1['file_pdf'];	
$diskon 	= $hasil1['diskon'];			
$harga_final 	= $hasil1['harga_final'];			
$status_persetujuan 	= $hasil1['status_persetujuan'];	

$lokasi_file 	= 'qr_code/2.surat_penawaran_lingkungan/'.$id.'.png';
if(file_exists($lokasi_file)){unlink($lokasi_file);}
// creates qrcode
QRcode::png($file_pdf, $lokasi_file); 


$pdf->AddPage();
$pdf->setSourceFile('kop_surat_vander.pdf');
$tplIdx = $pdf->importPage(1);
$pdf->useTemplate($tplIdx, 0, 0, 210);
$pdf->SetTitle('surat_penawaran');
$pdf->SetFont('Arial','',11);

//--- header ---//
$pdf->SetXY(15, 35);
$pdf->Cell(30,5,'Nomor',0,0,'L');
$pdf->Cell(150,5,' : '.$nomor_surat,0,1,'L');
$pdf->SetX(15);
$pdf->Cell(30,5,'Perihal',0,0,'L');
$pdf->SetFont('Arial','B',11);
$pdf->Cell(150,5,' : Penawaran Harga Uji Laboratorium',0,1,'L');
$pdf->SetFont('Arial','',11);

$pdf->SetXY(15, 48);
$pdf->Cell(185,5,'Kepada Yth',0,1,'L');
$pdf->SetFont('Arial','B',11);
$pdf->SetX(15);
$pdf->Cell(185,5,'Pimpinan',0,1,'L');
$pdf->SetX(15);
$pdf->Cell(185,5,$hasil1['nama'],0,1,'L');
$pdf->SetFont('Arial','',11);
$pdf->SetXY(15, 62);
$pdf->SetX(15);
$pdf->Cell(185,5,'Di-',0,1,'L');
$pdf->SetX(25);
$pdf->Cell(185,5,'Tempat',0,1,'L');

$pdf->SetXY(15, 75);
$pdf->SetX(15);
$pdf->Cell(185,5,'Dengan hormat,',0,1,'L');
$pdf->SetX(15);
//$pdf->Cell(185,5,'Berikut Kami Lampirkan Price List Analisa Sample Geotek sebagai berikut:',0,1,'L');
$pdf->MultiCell(185, 5, 'Sehubungan dengan rencana '.$hasil1['nama'].' yang akan melakukan Analisis kualitas lingkungan, untuk itu kami atas nama Management PT. VANDER GEO LABORATORY memberi penawaran harga uji sampel sebagai berikut', 0, 'J', FALSE);

   
$pdf->SetXY(15, 97);
$pdf->SetFont('Arial','B',8);
$pdf->SetX(15);
$pdf->Cell(10,10,'NO',1,0,'C');
$pdf->Cell(75,10,'UJI',1,0,'C');
$x = $pdf->GetX(); 
$y = $pdf->GetY(); 
$pdf->Cell(40,5,'UNIT',1,1,'C');
$pdf->SetXY($x,$y+5);
$pdf->Cell(20,5,'Volume',1,0,'C');
$pdf->Cell(20,5,'Satuan',1,0,'C');
$pdf->SetXY($x+40,$y);
$pdf->Cell(30,10,'HARGA SATUAN',1,0,'C');
$pdf->Cell(30,10,'JUMLAH',1,1,'C');



$query ="select 
			t1.l2_daftar_penawaran_lingkungan_detail ,
			t1.id_l2_daftar_penawaran_lingkungan ,
			t1.id_l2_kategori_penawaran_lingkungan ,
			t1.id_l2_sub_kategori_penawaran_lingkungan ,
			t1.id_l2_sub_sub_kategori_penawaran_lingkungan ,
			t1.nama ,
			t1.output ,
			t1.satuan ,
			t1.volume ,
			t1.harga ,
			t1.urutan ,
			t1.diskon ,
			t1.banyak ,
			t1.sub_total
		from l2_daftar_penawaran_lingkungan_detail t1						
		where 	t1.id_l2_kategori_penawaran_lingkungan >0
		and t1.id_l2_daftar_penawaran_lingkungan = '$id_l2_daftar_penawaran_lingkungan'
		and t1.id_l2_sub_kategori_penawaran_lingkungan = 0
		and t1.id_l2_sub_sub_kategori_penawaran_lingkungan = 0
		order by t1.urutan asc
		";
$a=1;
$stid1 = pg_query($conn, $query);
$new_page = 0;
while($hasil1 = pg_fetch_array($stid1)){
	$id_l2_kategori_penawaran_lingkungan = $hasil1['id_l2_kategori_penawaran_lingkungan'];
	$posisi_y = $pdf->GetY();
	$jumlah_huruf = strlen($hasil1['nama']);
	$banyak_baris = ceil($jumlah_huruf/47);
	$pdf->SetFont('Arial','B',8);
	$pdf->SetX(15);
	$pdf->Cell(10,5*$banyak_baris,$a,'LTR',0,'C',0); 
	if($hasil1['nama']){			
		if($banyak_baris>1){
			$y = $pdf->GetY();
			$x = $pdf->GetX();
			$width = 75;
			$pdf->MultiCell($width, 5, $hasil1['nama'], 1, 'L', FALSE);
			$pdf->SetXY($x + $width, $y);
		}else{
			$pdf->Cell(75,5*$banyak_baris,$hasil1['nama'],1,0,'L');	
		}
	}else{
		$pdf->Cell(75,5*$banyak_baris,'',1,0,'C');	
	}
	
	$pdf->SetFont('Arial','',8);
	if($hasil1['banyak']){
		$pdf->Cell(20,5*$banyak_baris,$hasil1['banyak'],1,0,'C');
	}else{
		$pdf->Cell(20,5*$banyak_baris,'',1,0,'C');
	};
	if($hasil1['satuan']){
		$pdf->Cell(20,5*$banyak_baris,$hasil1['satuan'],1,0,'C');
	}else{
		$pdf->Cell(20,5*$banyak_baris,'',1,0,'C');
	}	
	if($hasil1['harga']){
		if($hasil1['diskon']>0){
			$diskon2 	= $hasil1['harga']*($hasil1['diskon']/100);
			$harga 		= $hasil1['harga'] - $diskon2;
		}else{
			$harga 		= $hasil1['harga'];
		}
		$pdf->Cell(30,5*$banyak_baris,number_format($harga),1,0,'R');
	}else{
		$pdf->Cell(30,5*$banyak_baris,'',1,0,'R');
	};
	if($hasil1['sub_total']){
		$pdf->Cell(30,5*$banyak_baris,number_format($hasil1['sub_total']),1,1,'R');
	}else{
		$pdf->Cell(30,5*$banyak_baris,'',1,1,'R');
	};
	if($posisi_y>=225){
		$pdf->AddPage();
		$pdf->setSourceFile('kop_surat_vander.pdf');
		$tplIdx = $pdf->importPage(1);
		$pdf->useTemplate($tplIdx, 0, 0, 210);
		$pdf->SetY(45);
	}
	//---- sub kategori penawaran ---//
	$query2 ="select 
			t1.l2_daftar_penawaran_lingkungan_detail ,
			t1.id_l2_daftar_penawaran_lingkungan ,
			t1.id_l2_kategori_penawaran_lingkungan ,
			t1.id_l2_sub_kategori_penawaran_lingkungan ,
			t1.id_l2_sub_sub_kategori_penawaran_lingkungan ,
			t1.nama ,
			t1.output ,
			t1.satuan ,
			t1.volume ,
			t1.harga ,
			t1.urutan ,
			t1.diskon ,
			t1.banyak ,
			t1.sub_total,
			t1.file_symbol
		from l2_daftar_penawaran_lingkungan_detail t1						
		where 	t1.id_l2_kategori_penawaran_lingkungan >0
		and t1.id_l2_daftar_penawaran_lingkungan = '$id_l2_daftar_penawaran_lingkungan'
		and id_l2_kategori_penawaran_lingkungan = '$id_l2_kategori_penawaran_lingkungan'
		and t1.id_l2_sub_kategori_penawaran_lingkungan != 0	
		and t1.id_l2_sub_sub_kategori_penawaran_lingkungan = 0	
		order by t1.urutan asc
	";
	$stid2 = pg_query($conn, $query2);
	$b=1;
	$new_page2 = 0;
	while($hasil2 = pg_fetch_array($stid2)){
		$id_l2_sub_kategori_penawaran_lingkungan = $hasil2['id_l2_sub_kategori_penawaran_lingkungan'];
		$posisi_y = $pdf->GetY();
		$jumlah_huruf = strlen($hasil2['nama']);
		$banyak_baris = ceil($jumlah_huruf/55);
		$pdf->SetFont('Arial','',8);
		$pdf->SetX(15);
		$pdf->Cell(10,5*$banyak_baris,'','LR',0,'C',0); 
		if($hasil2['nama']){			
			if($banyak_baris>1){
				$y = $pdf->GetY();
				$x = $pdf->GetX();
				$width = 75;
				$pdf->MultiCell($width, 5, ' - '.$hasil2['nama'], 1, 'L', FALSE);
				$pdf->SetXY($x + $width, $y);
			}else{
				$pdf->Cell(75,5*$banyak_baris,' - '.$hasil2['nama'],1,0,'L');	
			}
		}else{
			$pdf->Cell(75,5*$banyak_baris,'',1,0,'C');	
		}
		
		if($hasil2['banyak']){
			$pdf->Cell(20,5*$banyak_baris,$hasil2['banyak'],1,0,'C');
		}else{
			$pdf->Cell(20,5*$banyak_baris,'',1,0,'C');
		};
		if($hasil2['satuan']){
			$pdf->Cell(20,5*$banyak_baris,$hasil2['satuan'],1,0,'C');
		}else{
			$pdf->Cell(20,5*$banyak_baris,'',1,0,'C');
		}
		
		if($hasil2['harga']){
			if($hasil2['diskon']>0){
				$diskon2 	= $hasil2['harga']*($hasil2['diskon']/100);
				$harga 		= $hasil2['harga'] - $diskon2;
			}else{
				$harga 		= $hasil2['harga'];
			}
			$pdf->Cell(30,5*$banyak_baris,number_format($harga),1,0,'R');
		}else{
			$pdf->Cell(30,5*$banyak_baris,'',1,0,'R');
		};
		if($hasil2['sub_total']){
			$pdf->Cell(30,5*$banyak_baris,number_format($hasil2['sub_total']),1,1,'R');
		}else{
			$pdf->Cell(30,5*$banyak_baris,'',1,1,'R');
		};		
		if($posisi_y>=225){
			$pdf->AddPage();
			$pdf->setSourceFile('kop_surat_vander.pdf');
			$tplIdx = $pdf->importPage(1);
			$pdf->useTemplate($tplIdx, 0, 0, 210);
			$pdf->SetY(45);
		}
			
		$b++;
	}
	
	$a++;
	
}
$posisi_y = $pdf->GetY();
if($posisi_y>=210){
	$pdf->AddPage();
	$pdf->setSourceFile('kop_surat_vander.pdf');
	$tplIdx = $pdf->importPage(1);
	$pdf->useTemplate($tplIdx, 0, 0, 210);
	$pdf->SetY(45);
}
//dihilangkan subtotalnya
/*
if($diskon==0){
$pdf->SetFont('Arial','B',8);
$pdf->SetX(15);
$pdf->Cell(155,5,'SUBTOTAL',1,0,'R');
$pdf->Cell(30,5,number_format($sum_total),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'PPN',1,0,'R');
$pdf->Cell(30,5,number_format(0.11*$sum_total),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'TOTAL',1,0,'R');
$pdf->Cell(30,5,number_format(1.11*$sum_total),1,1,'R');
}else{
$pdf->SetFont('Arial','B',8);
$pdf->SetX(15);
$pdf->Cell(155,5,'SUBTOTAL',1,0,'R');
$pdf->Cell(30,5,number_format($sum_total),1,1,'R');

$harga_diskon = $sum_total*($diskon/100);
$sub_total2 = $sum_total - $harga_diskon;
$pdf->SetX(15);
$pdf->Cell(155,5,'Diskon(%)',1,0,'R');
$pdf->Cell(30,5,'-'.number_format($sum_total*($diskon/100)),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'SUBTOTAL Dikurangi Diskon',1,0,'R');
$pdf->Cell(30,5,number_format($sub_total2),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'PPN',1,0,'R');
$pdf->Cell(30,5,number_format(0.11*$sub_total2),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'TOTAL',1,0,'R');
$pdf->Cell(30,5,number_format(1.11*$harga_final),1,1,'R');	
}
*/

$pdf->SetFont('Arial','B',8);
$pdf->SetX(15);
$pdf->Cell(155,5,'SUBTOTAL',1,0,'R');
$pdf->Cell(30,5,number_format($sum_total),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'PPN',1,0,'R');
$pdf->Cell(30,5,number_format(0.11*$sum_total),1,1,'R');
$pdf->SetX(15);
$pdf->Cell(155,5,'TOTAL',1,0,'R');
$pdf->Cell(30,5,number_format(1.11*$sum_total),1,1,'R');


$pdf->SetFont('Arial','I',8);
$pdf->SetX(15);
//$pdf->Cell(160,5,'*Include PPN',0,1,'L');
$pdf->Cell(160,5,'',0,1,'L');
$pdf->SetX(15);
//$pdf->Cell(160,5,'*Biaya belum termasuk transportasi dan konsumsi petugas pengambil contoh di lapangan',0,1,'L');
//---- halaman ke 2 ---//
/*


*/
$pdf->SetTitle('surat_penawaran');
$pdf->SetFont('Arial','',11);
//--- header ---//
$pdf->Cell(185,2,'',0,1,'L');
$pdf->SetX(15);
$pdf->MultiCell(185, 5, 'Demikian Penawaran Harga ini kami sampaikan, yang nantinya dapat sebagai bahan pertimbangan. Atas perhatiannya kami ucapkan terimakasih.', 0, 'J', FALSE);
//$pdf->Cell(185,5,'Demikian Price List ini kami sampaikan, yang nantinya dapat sebagai bahan pertimbangan. Atas',0,1,'L');
$pdf->SetX(15);
//$pdf->Cell(185,5,'perhatiannya kami ucapkan terimakasih.',0,1,'L');

//$pdf->Cell(185,5,'',0,1,'L');
$pdf->Cell(185,5,'',0,1,'L');
$pdf->SetX(145);
if($status_persetujuan == 5){
$tanggal_approval2 	= format_tanggal_bulan_text($tanggal_approval);
$pdf->Cell(55,5,'Samarinda, '.$tanggal_approval2,0,1,'L');	
}else{
$pdf->Cell(55,5,'Samarinda, '.$tanggal_penawaran2,0,1,'L');
}
$posisi_x = $pdf->GetX();
$posisi_y = $pdf->GetY();

if($status_persetujuan == 6){
	$pdf->Image('qr_code/2.surat_penawaran_lingkungan/'.$id.'.png',160,$posisi_y,20,20);
	$pdf->SetXY(142,$posisi_y+20);
	$pdf->SetFont('Arial','B',11);
	$pdf->Cell(55,5,'Donny A. Kismat, S.T',0,1,'C');
	$pdf->SetX(142);
	$pdf->SetFont('Arial','',11);
	$pdf->Cell(55,5,'Direktur Utama',0,1,'C');
}else{
	$pdf->SetXY(15,$posisi_y+10);
	$pdf->SetFont('Arial','B',32);
	$pdf->Cell(185,5,'DRAFT SURAT PENAWARAN',0,1,'C');
}
/*
$pdf->Image('qr_code/2.surat_penawaran_lingkungan/'.$id.'.png',160,$posisi_y+5,30,30);
$pdf->SetXY(147,$posisi_y+35);
$pdf->SetFont('Arial','B',11);
$pdf->Cell(55,5,'Donny A. Kismat, S.T',0,1,'C');
$pdf->SetX(147);
$pdf->SetFont('Arial','',11);
$pdf->Cell(55,5,'Direktur Utama',0,1,'C');
*/

$pdf->Output();
$id_enkrip = str_replace("/","",$id_enkrip);
$id_enkrip = str_replace("@","",$id_enkrip);
$id_enkrip = str_replace("=","",$id_enkrip);
$filename="upload/file_pdf_surat_penawaran_lingkungan/".$id_enkrip.".pdf";
$pdf->Output($filename,'F');
